/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.impl.Log;

public class ResolutionContext {
    private static final Log log = Log.LogFactory.getLog(ResolutionContext.class);
    private final FileDescriptorSource.ProgressCallback progressCallback;
    private final Map<String, FileDescriptor> fileDescriptorMap;
    private final Map<Integer, GenericDescriptor> allTypeIds;
    private final Map<Integer, GenericDescriptor> typeIds = new HashMap<Integer, GenericDescriptor>();
    private Map<String, GenericDescriptor> allGlobalTypes;
    private Map<String, GenericDescriptor> globalTypes = new HashMap<String, GenericDescriptor>();
    private Map<String, EnumValueDescriptor> allEnumValueDescriptors;
    private Map<String, EnumValueDescriptor> enumValueDescriptors = new HashMap<String, EnumValueDescriptor>();

    public ResolutionContext(FileDescriptorSource.ProgressCallback progressCallback, Map<String, FileDescriptor> fileDescriptorMap, Map<String, GenericDescriptor> allGlobalTypes, Map<Integer, GenericDescriptor> allTypeIds, Map<String, EnumValueDescriptor> allEnumValueDescriptors) {
        this.progressCallback = progressCallback;
        this.fileDescriptorMap = fileDescriptorMap;
        this.allGlobalTypes = allGlobalTypes;
        this.allTypeIds = allTypeIds;
        this.allEnumValueDescriptors = allEnumValueDescriptors;
    }

    void handleError(FileDescriptor fileDescriptor, DescriptorParserException dpe) {
        if (log.isDebugEnabled()) {
            log.debugf(dpe, "File has errors : %s", fileDescriptor.getName());
        }
        fileDescriptor.status = FileDescriptor.Status.ERROR;
        if (this.progressCallback == null) {
            throw dpe;
        }
        this.progressCallback.handleError(fileDescriptor.getName(), dpe);
    }

    void handleSuccess(FileDescriptor fileDescriptor) {
        if (log.isDebugEnabled()) {
            log.debugf("File resolved successfully : %s", fileDescriptor.getName());
        }
        if (this.progressCallback != null) {
            this.progressCallback.handleSuccess(fileDescriptor.getName());
        }
    }

    Map<String, FileDescriptor> getFileDescriptorMap() {
        return this.fileDescriptorMap;
    }

    void addGenericDescriptor(GenericDescriptor genericDescriptor) {
        this.checkUniqueName(genericDescriptor);
        if (genericDescriptor.getTypeId() != null) {
            this.checkUniqueTypeId(genericDescriptor);
            this.typeIds.put(genericDescriptor.getTypeId(), genericDescriptor);
        }
        this.globalTypes.put(genericDescriptor.getFullName(), genericDescriptor);
        if (genericDescriptor instanceof EnumDescriptor) {
            EnumDescriptor enumDescriptor = (EnumDescriptor)genericDescriptor;
            for (EnumValueDescriptor ev : enumDescriptor.getValues()) {
                this.enumValueDescriptors.put(ev.getScopedName(), ev);
            }
        }
    }

    private void checkUniqueName(GenericDescriptor genericDescriptor) {
        GenericDescriptor existingGenericDescriptor = this.lookup(this.globalTypes, this.allGlobalTypes, genericDescriptor.getFullName());
        if (existingGenericDescriptor != null) {
            List<String> locations = Arrays.asList(genericDescriptor.getFileDescriptor().getName(), existingGenericDescriptor.getFileDescriptor().getName());
            if (locations.get(0).equals(locations.get(1))) {
                throw new DescriptorParserException("Duplicate definition of " + genericDescriptor.getFullName() + " in " + locations.get(0));
            }
            Collections.sort(locations);
            throw new DescriptorParserException("Duplicate definition of " + genericDescriptor.getFullName() + " in " + locations.get(0) + " and " + locations.get(1));
        }
        EnumValueDescriptor existingEnumValueDescriptor = this.lookup(this.enumValueDescriptors, this.allEnumValueDescriptors, genericDescriptor.getFullName());
        if (existingEnumValueDescriptor != null) {
            List<String> locations = Arrays.asList(genericDescriptor.getFileDescriptor().getName(), existingEnumValueDescriptor.getFileDescriptor().getName());
            Collections.sort(locations);
            throw new DescriptorParserException((genericDescriptor instanceof EnumDescriptor ? "Enum" : "Message") + " definition " + genericDescriptor.getFullName() + " clashes with enum value " + existingEnumValueDescriptor.getFullName());
        }
        if (genericDescriptor instanceof EnumDescriptor) {
            EnumDescriptor enumDescriptor = (EnumDescriptor)genericDescriptor;
            for (EnumValueDescriptor ev : enumDescriptor.getValues()) {
                existingEnumValueDescriptor = this.lookup(this.enumValueDescriptors, this.allEnumValueDescriptors, ev.getScopedName());
                if (existingEnumValueDescriptor != null) {
                    throw new DescriptorParserException("Enum value " + ev.getFullName() + " clashes with enum value " + existingEnumValueDescriptor.getFullName());
                }
                existingGenericDescriptor = this.lookup(this.globalTypes, this.allGlobalTypes, ev.getScopedName());
                if (existingGenericDescriptor == null) continue;
                throw new DescriptorParserException("Enum value " + ev.getFullName() + " clashes with " + (existingGenericDescriptor instanceof EnumDescriptor ? "enum" : "message") + " definition " + existingGenericDescriptor.getFullName());
            }
        }
    }

    private void checkUniqueTypeId(GenericDescriptor descriptor) {
        GenericDescriptor existing = this.lookup(this.typeIds, this.allTypeIds, descriptor.getTypeId());
        if (existing != null) {
            throw new DescriptorParserException("Duplicate type id " + descriptor.getTypeId() + " for type " + descriptor.getFullName() + ". Already used by " + existing.getFullName());
        }
    }

    private <K, V> V lookup(Map<K, V> first, Map<K, V> second, K k) {
        V v = first.get(k);
        return v != null ? v : second.get(k);
    }

    void flush() {
        this.allGlobalTypes.putAll(this.globalTypes);
        this.allTypeIds.putAll(this.typeIds);
        this.allEnumValueDescriptors.putAll(this.enumValueDescriptors);
        this.clear();
    }

    void clear() {
        this.globalTypes.clear();
        this.typeIds.clear();
        this.enumValueDescriptors.clear();
    }
}

