/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.util.Collection;
import java.util.Set;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;

public final class ElasticsearchEntityHelper {
    private ElasticsearchEntityHelper() {
    }

    public static boolean isMappedToElasticsearch(ExtendedSearchIntegrator integrator, Class<?> entityType) {
        Set entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(new Class[]{entityType});
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    public static boolean isAnyMappedToElasticsearch(ExtendedSearchIntegrator integrator, Collection<Class<?>> entityTypes) {
        Set entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(entityTypes.toArray(new Class[entityTypes.size()]));
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    private static boolean hasElasticsearchIndexManager(ExtendedSearchIntegrator integrator, Collection<Class<?>> entityTypes) {
        for (Class<?> entityType : entityTypes) {
            IndexManager[] indexManagers;
            EntityIndexBinding binding = integrator.getIndexBinding(entityType);
            if (binding == null) continue;
            for (IndexManager indexManager : indexManagers = binding.getIndexManagers()) {
                if (!(indexManager instanceof ElasticsearchIndexManager)) continue;
                return true;
            }
        }
        return false;
    }
}

