/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.subsystem.EncryptableSubsystemHelper;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServiceSubsystemAdd;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class HotRodSubsystemAdd
extends ProtocolServiceSubsystemAdd {
    static final ProtocolServiceSubsystemAdd INSTANCE = new HotRodSubsystemAdd();

    HotRodSubsystemAdd() {
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        HotRodSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_LIST_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.PROTOCOL_SERVICE_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        HotRodServerConfigurationBuilder configurationBuilder = new HotRodServerConfigurationBuilder();
        this.configureProtocolServer((ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder, config);
        this.configureProtocolServerAuthentication(configurationBuilder, config);
        this.configureProtocolServerTopology(configurationBuilder, config);
        ProtocolServerService service = new ProtocolServerService(this.getServiceName(operation), (Class<? extends ProtocolServer>)HotRodServer.class, (ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder);
        ServiceName hotRodServerServiceName = EndpointUtils.getServiceName(operation, "hotrod");
        ServiceBuilder builder = context.getServiceTarget().addService(hotRodServerServiceName, (Service)service);
        String cacheContainerName = this.getCacheContainerName(operation);
        EndpointUtils.addCacheContainerConfigurationDependency(builder, cacheContainerName, service.getCacheManagerConfiguration());
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        EndpointUtils.addSocketBindingDependency(builder, this.getSocketBindingName(operation), service.getSocketBinding());
        EncryptableSubsystemHelper.processEncryption(config, service, builder);
        this.processAuthentication(config, configurationBuilder, service, builder);
        builder.addDependency(Constants.EXTENSION_MANAGER_NAME, ExtensionManagerService.class, service.getExtensionManager());
        builder.install();
    }

    private void processAuthentication(ModelNode config, HotRodServerConfigurationBuilder configurationBuilder, ProtocolServerService service, ServiceBuilder<?> builder) {
        if (config.hasDefined("authentication") && config.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
            ModelNode authentication = config.get(new String[]{"authentication", "AUTHENTICATION"});
            EndpointUtils.addSecurityRealmDependency(builder, authentication.get("security-realm").asString(), service.getAuthenticationSecurityRealm());
            if (authentication.hasDefined("sasl") && authentication.get(new String[]{"sasl", "SASL"}).isDefined()) {
                String strength;
                String qop;
                AuthenticationConfigurationBuilder authenticationBuilder = configurationBuilder.authentication();
                ModelNode sasl = authentication.get(new String[]{"sasl", "SASL"});
                if (sasl.hasDefined("server-context-name")) {
                    String serverContextName = sasl.get("server-context-name").asString();
                    service.setServerContextName(serverContextName);
                    EndpointUtils.addSecurityDomainDependency(builder, serverContextName, service.getSaslSecurityDomain());
                }
                if (sasl.hasDefined("server-name")) {
                    authenticationBuilder.serverName(sasl.get("server-name").asString());
                }
                if (sasl.hasDefined("mechanisms")) {
                    for (ModelNode mech : sasl.get("mechanisms").asList()) {
                        authenticationBuilder.addAllowedMech(mech.asString());
                    }
                }
                if ((qop = this.listAsString(sasl, "qop")) != null) {
                    authenticationBuilder.addMechProperty("javax.security.sasl.qop", qop);
                }
                if ((strength = this.listAsString(sasl, "strength")) != null) {
                    authenticationBuilder.addMechProperty("javax.security.sasl.strength", strength);
                }
                if (sasl.hasDefined("property")) {
                    for (Property property : sasl.get("property").asPropertyList()) {
                        authenticationBuilder.addMechProperty(property.getName(), property.getValue().asProperty().getValue().asString());
                    }
                }
            }
        }
    }

    private String listAsString(ModelNode node, String name) {
        if (node.hasDefined(name)) {
            StringBuilder sb = new StringBuilder();
            for (ModelNode item : node.get(name).asList()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(item.asString());
            }
            return sb.toString();
        }
        return null;
    }

    private void configureProtocolServerTopology(HotRodServerConfigurationBuilder builder, ModelNode config) {
        if (config.hasDefined("topology-state-transfer") && config.get(new String[]{"topology-state-transfer", "TOPOLOGY_STATE_TRANSFER"}).isDefined()) {
            if ((config = config.get(new String[]{"topology-state-transfer", "TOPOLOGY_STATE_TRANSFER"})).hasDefined("lock-timeout")) {
                builder.topologyLockTimeout(config.get("lock-timeout").asLong());
            }
            if (config.hasDefined("replication-timeout")) {
                builder.topologyReplTimeout(config.get("replication-timeout").asLong());
            }
            if (config.hasDefined("external-host")) {
                builder.proxyHost(config.get("external-host").asString());
            }
            if (config.hasDefined("external-port")) {
                builder.proxyPort(config.get("external-port").asInt());
            }
            if (config.hasDefined("lazy-retrieval")) {
                builder.topologyStateTransfer(!config.get("lazy-retrieval").asBoolean(false));
            }
            if (config.hasDefined("await-initial-retrieval")) {
                builder.topologyAwaitInitialTransfer(config.get("await-initial-retrieval").asBoolean());
            }
        }
    }

    private void configureProtocolServerAuthentication(HotRodServerConfigurationBuilder builder, ModelNode config) {
        if (config.hasDefined("authentication") && config.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
            config = config.get(new String[]{"authentication", "AUTHENTICATION"});
            builder.authentication().enable();
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

