/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Optional;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.MultiTenantRouterService;
import org.infinispan.server.endpoint.subsystem.RouterConnectorResource;
import org.infinispan.server.router.configuration.builder.MultiTenantRouterConfigurationBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class RouterSubsystemAdd
extends AbstractAddStepHandler {
    static final RouterSubsystemAdd INSTANCE = new RouterSubsystemAdd();

    RouterSubsystemAdd() {
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition attr : RouterConnectorResource.ROUTER_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MultiTenantRouterConfigurationBuilder configuration = new MultiTenantRouterConfigurationBuilder();
        MultiTenantRouterService routerService = new MultiTenantRouterService(configuration, this.getServiceName(config));
        ServiceName MultitenantRouterServiceName = EndpointUtils.getServiceName(operation, "router");
        ServiceBuilder builder = context.getServiceTarget().addService(MultitenantRouterServiceName, (Service)routerService);
        EndpointUtils.addSocketBindingDependency(builder, operation.get("hotrod-socket-binding").asString(), routerService.getHotrodSocketBinding());
        EndpointUtils.addSocketBindingDependency(builder, operation.get("rest-socket-binding").asString(), routerService.getRestSocketBinding());
        ModelNode multiTenancyInnerConfiguration = config.get(new String[]{"multi-tenancy", "MULTI_TENANCY"});
        this.addHotRod(multiTenancyInnerConfiguration, routerService, builder);
        this.addRest(multiTenancyInnerConfiguration, routerService, builder);
        builder.install();
    }

    private void addRest(ModelNode config, MultiTenantRouterService routerService, ServiceBuilder<?> builder) {
        if (config.get("rest").isDefined()) {
            config.get("rest").asList().forEach(r -> {
                String restName = r.get(0).get("name").asString();
                if (r.get(0).get("prefix").isDefined()) {
                    r.get(0).get("prefix").asList().forEach(prefix -> {
                        String pathPrefix = prefix.get(0).get("path").asString();
                        MultiTenantRouterService.RestRouting restRouting = routerService.getRestRouting(pathPrefix, restName);
                        EndpointUtils.addRestDependency(builder, restName, restRouting.getRest());
                    });
                }
            });
        }
    }

    private void addHotRod(ModelNode config, MultiTenantRouterService routerService, ServiceBuilder<?> builder) {
        if (config.get("hotrod").isDefined()) {
            config.get("hotrod").asList().forEach(hr -> {
                String hotRodName = hr.get(0).get("name").asString();
                routerService.tcpNoDelay(hr.get(0).get("tcp-nodelay").asBoolean(true));
                routerService.keepAlive(hr.get(0).get("keep-alive").asBoolean(false));
                routerService.sendBufferSize(hr.get(0).get("send-buffer-size").asInt(0));
                routerService.receiveBufferSize(hr.get(0).get("receive-buffer-size").asInt(0));
                if (hr.get(0).get("sni").isDefined()) {
                    hr.get(0).get("sni").asList().forEach(sni -> {
                        String sniHostName = sni.get(0).get("host-name").asString();
                        String securityRealm = sni.get(0).get("security-realm").asString();
                        MultiTenantRouterService.HotRodRouting hotRodRouting = routerService.getHotRodRouting(sniHostName);
                        EndpointUtils.addHotRodDependency(builder, hotRodName, hotRodRouting.getHotRod());
                        EndpointUtils.addSecurityRealmDependency(builder, securityRealm, hotRodRouting.getSecurityRealm());
                    });
                }
            });
        }
    }

    private Optional<String> getServiceName(ModelNode config) {
        return Optional.ofNullable(config.get("name")).map(ModelNode::asString);
    }
}

