/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneAnalyzerReference
implements AnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private String name;
    private Analyzer analyzer;

    public LuceneAnalyzerReference(String name) {
        this.name = name;
        this.analyzer = null;
    }

    public LuceneAnalyzerReference(Analyzer analyzer) {
        this.name = null;
        this.analyzer = analyzer;
    }

    @Override
    public String getAnalyzerName() {
        return this.name;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyLuceneAnalyzerReferenceNotInitialized(this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize(Analyzer analyzer) {
        if (this.analyzer != null) {
            throw new AssertionFailure("An analyzer reference has been initialized more than once:" + this);
        }
        this.analyzer = analyzer;
    }

    @Override
    public void close() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    @Override
    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        return analyzerType.isAssignableFrom(LuceneAnalyzerReference.class);
    }

    @Override
    public <T extends AnalyzerReference> T unwrap(Class<T> analyzerType) {
        return (T)((AnalyzerReference)analyzerType.cast(this));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        if (this.analyzer != null) {
            sb.append(this.analyzer);
        } else {
            sb.append(this.name);
        }
        sb.append(">");
        return sb.toString();
    }
}

