/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> SortedMap<K, V> newSortedMap() {
        return new TreeMap();
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <T> Set<T> asSet(T ... ts) {
        HashSet set = new HashSet(ts.length);
        Collections.addAll(set, ts);
        return set;
    }

    public static <T> List<T> toImmutableList(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public static Set<String> asImmutableSet(String[] names) {
        if (names == null || names.length == 0) {
            return Collections.emptySet();
        }
        if (names.length == 1) {
            return Collections.singleton(names[0]);
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(names));
        return Collections.unmodifiableSet(hashSet);
    }
}

