/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
interface LinkedDeque<E>
extends Deque<E> {
    public boolean isFirst(E var1);

    public boolean isLast(E var1);

    public void moveToFront(E var1);

    public void moveToBack(E var1);

    public E getPrevious(E var1);

    public void setPrevious(E var1, E var2);

    public E getNext(E var1);

    public void setNext(E var1, E var2);

    @Override
    public PeekingIterator<E> iterator();

    @Override
    public PeekingIterator<E> descendingIterator();

    public static interface PeekingIterator<E>
    extends Iterator<E> {
        public E peek();

        public static <E> PeekingIterator<E> concat(final PeekingIterator<E> first, final PeekingIterator<E> second) {
            return new PeekingIterator<E>(){

                @Override
                public boolean hasNext() {
                    return first.hasNext() || second.hasNext();
                }

                @Override
                public E next() {
                    if (first.hasNext()) {
                        return first.next();
                    }
                    if (second.hasNext()) {
                        return second.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public E peek() {
                    return first.hasNext() ? first.peek() : second.peek();
                }
            };
        }

        public static <E> PeekingIterator<E> comparing(final PeekingIterator<E> first, final PeekingIterator<E> second, final Comparator<E> comparator) {
            return new PeekingIterator<E>(){

                @Override
                public boolean hasNext() {
                    return first.hasNext() || second.hasNext();
                }

                @Override
                public E next() {
                    if (!first.hasNext()) {
                        return second.next();
                    }
                    if (!second.hasNext()) {
                        return first.next();
                    }
                    boolean greaterOrEqual = comparator.compare(first.peek(), second.peek()) >= 0;
                    return greaterOrEqual ? first.next() : second.next();
                }

                @Override
                public E peek() {
                    if (!first.hasNext()) {
                        return second.peek();
                    }
                    if (!second.hasNext()) {
                        return first.peek();
                    }
                    boolean greaterOrEqual = comparator.compare(first.peek(), second.peek()) >= 0;
                    return greaterOrEqual ? first.peek() : second.peek();
                }
            };
        }
    }
}

