/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;

public abstract class AbstractDelegatingCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> cache;

    public AbstractDelegatingCache(Cache<K, V> cache) {
        this.cache = cache;
        if (cache == null) {
            throw new IllegalArgumentException("Delegate cache cannot be null!");
        }
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cache.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.cache.putForExternalRead(key, value, lifespan, unit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.cache.putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void evict(K key) {
        this.cache.evict(key);
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public boolean startBatch() {
        return this.cache.startBatch();
    }

    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    public String getName() {
        return this.cache.getName();
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return this.cache.getVersion();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.put(key, value, lifespan, unit);
    }

    protected void set(K key, V value) {
        this.cache.put(key, value);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.putIfAbsent(key, value, lifespan, unit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.cache.putAll(map, lifespan, unit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.replace(key, value, lifespan, unit);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.cache.replace(key, oldValue, value, lifespan, unit);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.cache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.cache.replaceAll(function);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return this.cache.putAsync(key, value);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cache.putAllAsync(data);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.cache.putAllAsync(data, lifespan, unit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cache.putIfAbsentAsync(key, value);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return this.cache.removeAsync(key);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cache.removeAsync(key, value);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.cache.replaceAsync(key, value);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cache.replaceAsync(key, oldValue, newValue);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this.cache.getAdvancedCache();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.cache.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.cache.putIfAbsent(key, value);
    }

    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(key, oldValue, newValue);
    }

    public V replace(K key, V value) {
        return (V)this.cache.replace(key, value);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.cache.compute(key, remappingFunction);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.cache.computeIfPresent(key, remappingFunction);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.cache.computeIfAbsent(key, mappingFunction);
    }

    public V get(Object key) {
        return (V)this.cache.get(key);
    }

    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.cache.getOrDefault(key, defaultValue);
    }

    public V put(K key, V value) {
        return (V)this.cache.put(key, value);
    }

    public V remove(Object key) {
        return (V)this.cache.remove(key);
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        this.cache.putAll(t);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.cache.merge(key, value, remappingFunction);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.cache.forEach(action);
    }

    @Override
    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public void clear() {
        this.cache.clear();
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public CacheCollection<V> values() {
        return this.cache.values();
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.cache.start();
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.cache.stop();
    }

    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        this.cache.shutdown();
    }

    @Override
    public void addListener(Object listener) {
        this.cache.addListener(listener);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.cache.addListener(listener, filter);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.cache.addListener(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.cache.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.cache.getListeners();
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.cache.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.cache.getAsync(key);
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.getCacheConfiguration());
    }

    public String toString() {
        return this.cache.toString();
    }

    public Cache<K, V> getDelegate() {
        return this.cache;
    }

    public static <K, V> Cache unwrapCache(Cache<K, V> cache) {
        if (cache instanceof AbstractDelegatingCache) {
            return AbstractDelegatingCache.unwrapCache(((AbstractDelegatingCache)cache).getDelegate());
        }
        return cache;
    }
}

