/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class BackupAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 2;
    private CommandInvocationId commandInvocationId;
    private CommandAckCollector commandAckCollector;
    private int topologyId;

    public BackupAckCommand() {
        super(null);
    }

    public BackupAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public BackupAckCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId) {
        super(cacheName);
        this.commandInvocationId = commandInvocationId;
        this.topologyId = topologyId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.commandAckCollector.backupAck(this.commandInvocationId, this.getOrigin(), this.topologyId);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 2;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.topologyId = input.readInt();
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    @Override
    public String toString() {
        return "BackupAckCommand{commandInvocationId=" + this.commandInvocationId + ", topologyId=" + this.topologyId + '}';
    }
}

