/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationComposeSuccessHandler;
import org.infinispan.interceptors.InvocationExceptionHandler;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationReturnValueHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.ExceptionStage;
import org.infinispan.interceptors.impl.Stages;

public class ReturnValueStage
extends AbstractInvocationStage {
    private Object returnValue;

    public ReturnValueStage(InvocationContext ctx, VisitableCommand command, Object returnValue) {
        super(ctx, command);
        this.returnValue = returnValue;
    }

    @Override
    public InvocationStage compose(InvocationComposeHandler composeHandler) {
        try {
            BasicInvocationStage stage = composeHandler.apply(this, this.ctx, this.command, this.returnValue, null);
            return stage.toInvocationStage(this.ctx, this.command);
        }
        catch (Throwable t) {
            return new ExceptionStage(this.ctx, this.command, t);
        }
    }

    @Override
    public InvocationStage thenCompose(InvocationComposeSuccessHandler thenComposeHandler) {
        return this.compose(thenComposeHandler);
    }

    @Override
    public InvocationStage thenAccept(InvocationSuccessHandler successHandler) {
        try {
            successHandler.accept(this.ctx, this.command, this.returnValue);
            return this;
        }
        catch (Throwable t) {
            return new ExceptionStage(this.ctx, this.command, t);
        }
    }

    @Override
    public InvocationStage thenApply(InvocationReturnValueHandler returnValueHandler) {
        try {
            Object newReturnValue = returnValueHandler.apply(this.ctx, this.command, this.returnValue);
            this.updateValue(newReturnValue);
            return this;
        }
        catch (Throwable t) {
            return new ExceptionStage(this.ctx, this.command, t);
        }
    }

    @Override
    public InvocationStage exceptionally(InvocationExceptionHandler exceptionHandler) {
        return this;
    }

    @Override
    public InvocationStage handle(InvocationFinallyHandler finallyHandler) {
        try {
            finallyHandler.accept(this.ctx, this.command, this.returnValue, null);
            return this;
        }
        catch (Throwable t) {
            return new ExceptionStage(this.ctx, this.command, t);
        }
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return CompletableFuture.completedFuture(this.returnValue);
    }

    @Override
    public Object get() throws Throwable {
        return this.returnValue;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    private void updateValue(Object newReturnValue) {
        if (this.returnValue != newReturnValue) {
            this.returnValue = newReturnValue;
        }
    }

    public String toString() {
        return "ReturnValueStage(" + Stages.className(this.returnValue) + ")";
    }
}

