/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;

public class RpcOptions {
    private final long timeout;
    private final TimeUnit unit;
    private final ResponseFilter responseFilter;
    private final ResponseMode responseMode;
    private final DeliverOrder deliverOrder;

    @Deprecated
    public RpcOptions(long timeout, TimeUnit unit, ResponseFilter responseFilter, ResponseMode responseMode, boolean skipReplicationQueue, DeliverOrder deliverOrder) {
        this(timeout, unit, responseFilter, responseMode, deliverOrder);
    }

    public RpcOptions(long timeout, TimeUnit unit, ResponseFilter responseFilter, ResponseMode responseMode, DeliverOrder deliverOrder) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        if (responseMode == null) {
            throw new IllegalArgumentException("ResponseMode cannot be null");
        }
        if (deliverOrder == null) {
            throw new IllegalArgumentException("DeliverMode cannot be null");
        }
        this.timeout = timeout;
        this.unit = unit;
        this.responseFilter = responseFilter;
        this.responseMode = responseMode;
        this.deliverOrder = deliverOrder;
    }

    public long timeout() {
        return this.timeout;
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public DeliverOrder deliverOrder() {
        return this.deliverOrder;
    }

    public ResponseFilter responseFilter() {
        return this.responseFilter;
    }

    public ResponseMode responseMode() {
        return this.responseMode;
    }

    public boolean skipReplicationQueue() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcOptions options = (RpcOptions)o;
        if (this.timeout != options.timeout) {
            return false;
        }
        if (this.deliverOrder != options.deliverOrder) {
            return false;
        }
        if (this.responseFilter != null ? !this.responseFilter.equals(options.responseFilter) : options.responseFilter != null) {
            return false;
        }
        if (this.responseMode != options.responseMode) {
            return false;
        }
        return this.unit == options.unit;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + this.deliverOrder.hashCode();
        result = 31 * result + (this.responseFilter != null ? this.responseFilter.hashCode() : 0);
        result = 31 * result + this.responseMode.hashCode();
        return result;
    }

    public String toString() {
        return "RpcOptions{timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + ", deliverOrder=" + (Object)((Object)this.deliverOrder) + ", responseFilter=" + this.responseFilter + ", responseMode=" + (Object)((Object)this.responseMode) + '}';
    }
}

