/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentHashMap<CommandInvocationId, Collector<?>> collectorMap = new ConcurrentHashMap();
    private ScheduledExecutorService timeoutExecutor;
    private long timeoutNanoSeconds;

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, Configuration configuration) {
        this.timeoutExecutor = timeoutExecutor;
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(configuration.clustering().remoteTimeout());
    }

    public void create(CommandInvocationId id, Collection<Address> owners, int topologyId) {
        this.collectorMap.putIfAbsent(id, new SingleKeyCollector(id, owners, topologyId));
        if (trace) {
            log.tracef("Created new collector for %s. Owners=%s", id, owners);
        }
    }

    public void create(CommandInvocationId id, Object returnValue, Collection<Address> owners, int topologyId) {
        this.collectorMap.putIfAbsent(id, new SingleKeyCollector(id, returnValue, owners, topologyId));
        if (trace) {
            log.tracef("Created new collector for %s. ReturnValue=%s. Owners=%s", id, returnValue, owners);
        }
    }

    public void createMultiKeyCollector(CommandInvocationId id, Collection<Address> primary, Map<Address, Collection<Integer>> backups, int topologyId) {
        this.collectorMap.putIfAbsent(id, new MultiKeyCollector(id, primary, backups, topologyId));
        if (trace) {
            log.tracef("Created new collector for %s. Primary=%s. BackupSegments=%s", id, primary, backups);
        }
    }

    public void multiKeyPrimaryAck(CommandInvocationId id, Address from, Map<Object, Object> returnValue, int topologyId) {
        MultiKeyCollector collector = (MultiKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.primaryAck(returnValue, from, topologyId);
        }
    }

    public void multiKeyBackupAck(CommandInvocationId id, Address from, int segment, int topologyId) {
        MultiKeyCollector collector = (MultiKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void backupAck(CommandInvocationId id, Address from, int topologyId) {
        SingleKeyCollector collector = (SingleKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(topologyId, from);
        }
    }

    public void primaryAck(CommandInvocationId id, Object returnValue, boolean success, Address from, int topologyId) {
        SingleKeyCollector collector = (SingleKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.primaryAck(topologyId, returnValue, success, from);
        }
    }

    public void completeExceptionally(CommandInvocationId id, Throwable throwable, int topologyId) {
        Collector<?> collector = this.collectorMap.get(id);
        if (collector != null) {
            collector.completeExceptionally(throwable, topologyId);
        }
    }

    public <T> CompletableFuture<T> getCollectorCompletableFuture(CommandInvocationId id) {
        Collector<?> collector = this.collectorMap.get(id);
        return collector == null ? null : collector.getFuture();
    }

    public <T> CompletableFuture<T> getCollectorCompletableFutureToWait(CommandInvocationId id) {
        Collector<?> collector = this.collectorMap.get(id);
        if (collector == null) {
            return null;
        }
        if (trace) {
            log.tracef("[Collector#%s] Waiting for acks asynchronously.", id);
        }
        return collector.addCleanupTasksAndGetFuture();
    }

    public List<CommandInvocationId> getPendingCommands() {
        return new ArrayList<CommandInvocationId>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(CommandInvocationId id) {
        Collector<?> collector = this.collectorMap.get(id);
        return collector != null && collector.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        for (Collector<?> collector : this.collectorMap.values()) {
            collector.onMembersChange(currentMembers);
        }
    }

    public void dispose(CommandInvocationId id) {
        if (trace) {
            log.tracef("[Collector#%s] Dispose collector.", id);
        }
        this.collectorMap.remove(id);
    }

    private TimeoutException createTimeoutException() {
        return log.timeoutWaitingForAcks(Util.prettyPrintTime((long)this.timeoutNanoSeconds, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    private class MultiKeyCollector
    extends Collector<Map<Object, Object>> {
        @GuardedBy(value="this")
        private final Collection<Address> primary;
        @GuardedBy(value="this")
        private final Map<Address, Collection<Integer>> backups;
        @GuardedBy(value="this")
        private Map<Object, Object> returnValue;

        MultiKeyCollector(CommandInvocationId id, Collection<Address> primary, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.returnValue = null;
            this.backups = backups;
            this.primary = new HashSet<Address>(primary);
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (!members.containsAll(this.primary)) {
                if (trace) {
                    log.tracef("[Collector#%s] A primary Owner left the cluster.", this.id);
                }
                this.doCompleteExceptionally((Throwable)((Object)OutdatedTopologyException.getCachedInstance()));
            } else if (this.backups.keySet().retainAll(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        synchronized void primaryAck(Map<Object, Object> returnValue, Address from, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Primary ACK. Address=%s. TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.topologyId != topologyId) {
                return;
            }
            if (returnValue != null) {
                if (this.returnValue == null) {
                    this.returnValue = new HashMap<Object, Object>(returnValue.size());
                }
                this.returnValue.putAll(returnValue);
            }
            if (this.primary.remove(from)) {
                this.checkCompleted();
            }
        }

        synchronized void backupAck(Address from, int segment, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", new Object[]{this.id, from, topologyId, this.topologyId, segment});
            }
            if (this.topologyId != topologyId) {
                return;
            }
            Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
            if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                this.backups.remove(from);
                this.checkCompleted();
            }
        }

        @Override
        @GuardedBy(value="this")
        void doCompleteExceptionally(Throwable throwable) {
            this.returnValue = null;
            this.primary.clear();
            this.backups.clear();
            this.future.completeExceptionally(throwable);
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primary.isEmpty() && this.backups.isEmpty()) {
                if (trace) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.returnValue);
                }
                this.future.complete(this.returnValue);
            }
        }
    }

    private class SingleKeyCollector
    extends Collector<Object> {
        @GuardedBy(value="this")
        private final Collection<Address> owners;
        @GuardedBy(value="this")
        private final Address primaryOwner;
        @GuardedBy(value="this")
        private Object returnValue;

        private SingleKeyCollector(CommandInvocationId id, Collection<Address> owners, int topologyId) {
            super(id, topologyId);
            this.primaryOwner = owners.iterator().next();
            this.owners = new HashSet<Address>(owners);
        }

        private SingleKeyCollector(CommandInvocationId id, Object returnValue, Collection<Address> owners, int topologyId) {
            super(id, topologyId);
            this.returnValue = returnValue;
            this.primaryOwner = owners.iterator().next();
            HashSet<Address> tmpOwners = new HashSet<Address>(owners);
            tmpOwners.remove(this.primaryOwner);
            if (tmpOwners.isEmpty()) {
                this.owners = Collections.emptyList();
                this.future.complete(returnValue);
            } else {
                this.owners = tmpOwners;
            }
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return this.owners.size() > 1 || this.owners.size() == 1 && !this.primaryOwner.equals(this.owners.iterator().next());
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (!members.contains(this.primaryOwner)) {
                if (trace) {
                    log.tracef("[Collector#%s] The Primary Owner left the cluster.", this.id);
                }
                this.doCompleteExceptionally((Throwable)((Object)OutdatedTopologyException.getCachedInstance()));
            } else if (this.owners.retainAll(members) && this.owners.isEmpty()) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        synchronized void primaryAck(int topologyId, Object returnValue, boolean success, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] Primary ACK. Success=%s. ReturnValue=%s. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, success, returnValue, from, topologyId, this.topologyId});
            }
            if (this.topologyId != topologyId || !this.owners.remove(from)) {
                return;
            }
            this.returnValue = returnValue;
            if (!success) {
                this.owners.clear();
                this.future.complete(returnValue);
                if (trace) {
                    log.tracef("[Collector#%s] Ready! Command not succeed on primary.", this.id);
                }
            } else if (this.owners.isEmpty()) {
                this.markReady();
            }
        }

        synchronized void backupAck(int topologyId, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.topologyId == topologyId && this.owners.remove(from) && this.owners.isEmpty()) {
                this.markReady();
            }
        }

        @Override
        @GuardedBy(value="this")
        void doCompleteExceptionally(Throwable throwable) {
            this.owners.clear();
            this.future.completeExceptionally(throwable);
        }

        @GuardedBy(value="this")
        private void markReady() {
            if (trace) {
                log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.returnValue);
            }
            this.future.complete(this.returnValue);
        }
    }

    private abstract class Collector<T>
    implements Callable<Void>,
    BiConsumer<T, Throwable> {
        final CommandInvocationId id;
        final CompletableFuture<T> future;
        final int topologyId;
        private volatile ScheduledFuture<?> timeoutTask;

        protected Collector(CommandInvocationId id, int topologyId) {
            this.id = id;
            this.topologyId = topologyId;
            this.future = new CompletableFuture();
        }

        @Override
        public final synchronized Void call() throws Exception {
            this.doCompleteExceptionally((Throwable)((Object)CommandAckCollector.this.createTimeoutException()));
            return null;
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            CommandAckCollector.this.collectorMap.remove(this.id);
            this.timeoutTask.cancel(false);
        }

        final synchronized void completeExceptionally(Throwable throwable, int topologyId) {
            if (trace) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, topologyId, this.topologyId);
            }
            if (this.topologyId != topologyId) {
                return;
            }
            this.doCompleteExceptionally(throwable);
        }

        abstract boolean hasPendingBackupAcks();

        final CompletableFuture<T> getFuture() {
            return this.future;
        }

        abstract void onMembersChange(Collection<Address> var1);

        abstract void doCompleteExceptionally(Throwable var1);

        final CompletableFuture<T> addCleanupTasksAndGetFuture() {
            if (this.future.isDone()) {
                CommandAckCollector.this.collectorMap.remove(this.id);
                return this.future;
            }
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(this, CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
            return this.future.whenComplete((BiConsumer)this);
        }
    }
}

