/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.transaction.LockingMode;

public class Configurations {
    private Configurations() {
    }

    public static boolean isSecondPhaseAsync(Configuration cfg) {
        ClusteringConfiguration clusteringCfg = cfg.clustering();
        return !cfg.transaction().syncCommitPhase() || !clusteringCfg.cacheMode().isSynchronous();
    }

    public static boolean isOnePhaseCommit(Configuration cfg) {
        return !cfg.clustering().cacheMode().isSynchronous() || cfg.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    public static boolean isOnePhaseTotalOrderCommit(Configuration cfg) {
        return cfg.transaction().transactionProtocol().isTotalOrder() && !Configurations.isVersioningEnabled(cfg);
    }

    public static boolean isVersioningEnabled(Configuration cfg) {
        return cfg.locking().writeSkewCheck() && cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC && cfg.versioning().enabled();
    }

    public static boolean noDataLossOnJoiner(Configuration configuration) {
        if (!configuration.clustering().cacheMode().isClustered()) {
            return true;
        }
        if (Configurations.hasSharedCacheLoaderOrWriter(configuration)) {
            return true;
        }
        boolean usingStores = configuration.persistence().usingStores();
        boolean passivation = configuration.persistence().passivation();
        boolean fetchInMemoryState = configuration.clustering().stateTransfer().fetchInMemoryState();
        boolean fetchPersistenceState = configuration.persistence().fetchPersistentState();
        return usingStores && !passivation && (fetchInMemoryState || fetchPersistenceState) || usingStores && passivation && fetchInMemoryState && fetchPersistenceState || !usingStores && fetchInMemoryState;
    }

    public static boolean hasSharedCacheLoaderOrWriter(Configuration configuration) {
        for (StoreConfiguration storeConfiguration : configuration.persistence().stores()) {
            if (!storeConfiguration.shared()) continue;
            return true;
        }
        return false;
    }
}

