/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.logging.Log;

public abstract class AbstractLockingInterceptor
extends DDAsyncInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    protected LockManager lockManager;
    protected DataContainer<Object, Object> dataContainer;
    protected ClusteringDependentLogic cdl;
    protected final InvocationFinallyAction unlockAllReturnHandler = new InvocationFinallyAction(){

        @Override
        public void accept(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
            AbstractLockingInterceptor.this.lockManager.unlockAll(rCtx);
        }
    };

    protected abstract Log getLog();

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer<Object, Object> dataContainer, ClusteringDependentLogic cdl) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    protected abstract Object visitDataReadCommand(InvocationContext var1, DataCommand var2) throws Throwable;

    protected abstract Object visitDataWriteCommand(InvocationContext var1, DataWriteCommand var2) throws Throwable;

    protected final Object visitNonTxDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.hasSkipLocking(command) || !this.shouldLockKey(command.getKey())) {
            return this.invokeNext(ctx, command);
        }
        try {
            this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis(command));
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (this.hasSkipLocking(command)) {
            return this.invokeNext(ctx, command);
        }
        try {
            this.lockAllAndRecord(ctx, Arrays.asList(command.getKeys()), this.getLockTimeoutMillis(command));
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public final Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        if (command.isCausedByALocalWrite(this.cdl.getAddress())) {
            if (this.trace) {
                this.getLog().trace("Skipping invalidation as the write operation originated here.");
            }
            return null;
        }
        if (this.hasSkipLocking(command)) {
            return this.invokeNext(ctx, command);
        }
        Object[] keys = command.getKeys();
        if (keys == null || keys.length < 1) {
            return null;
        }
        ArrayList<Object> keysToInvalidate = new ArrayList<Object>(keys.length);
        for (Object key : keys) {
            try {
                this.lockAndRecord(ctx, key, 0L);
                keysToInvalidate.add(key);
            }
            catch (TimeoutException te) {
                this.getLog().unableToLockToInvalidate(key, this.cdl.getAddress());
            }
        }
        if (keysToInvalidate.isEmpty()) {
            return null;
        }
        command.setKeys(keysToInvalidate.toArray());
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            ((InvalidateL1Command)rCommand).setKeys(keys);
            if (!rCtx.isInTxScope()) {
                this.lockManager.unlockAll(rCtx);
            }
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getMap().keySet(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, command.getAffectedKeys(), command.isForwarded());
    }

    protected abstract <K> Object handleWriteManyCommand(InvocationContext var1, FlagAffectedCommand var2, Collection<K> var3, boolean var4) throws Throwable;

    protected final long getLockTimeoutMillis(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.cacheConfiguration.locking().lockAcquisitionTimeout();
    }

    protected final boolean shouldLockKey(Object key) {
        boolean shouldLock = LockUtil.isLockOwner(key, this.cdl);
        if (this.trace) {
            this.getLog().tracef("Are (%s) we the lock owners for key '%s'? %s", this.cdl.getAddress(), Util.toStr((Object)key), shouldLock);
        }
        return shouldLock;
    }

    protected final void lockAndRecord(InvocationContext context, Object key, long timeout) throws InterruptedException {
        context.addLockedKey(key);
        this.lockManager.lock(key, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).lock();
    }

    protected final void lockAllAndRecord(InvocationContext context, Stream<?> keys, long timeout) throws InterruptedException {
        this.lockAllAndRecord(context, keys.collect(Collectors.toList()), timeout);
    }

    protected final void lockAllAndRecord(InvocationContext context, Collection<?> keys, long timeout) throws InterruptedException {
        keys.forEach(context::addLockedKey);
        this.lockManager.lockAll(keys, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).lock();
    }

    protected final boolean hasSkipLocking(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }
}

