/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import org.infinispan.server.jgroups.LogFactory;
import org.infinispan.server.jgroups.subsystem.JGroupsModel;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemXMLReader;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jgroups.logging.CustomLogFactory;

public class JGroupsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datagrid-jgroups";

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, JGroupsModel.CURRENT.getVersion());
        registration.registerSubsystemModel((ResourceDefinition)new JGroupsSubsystemResourceDefinition(context.isRuntimeOnlyRegistrationValid()));
        registration.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            for (JGroupsModel model : EnumSet.complementOf(EnumSet.of(JGroupsModel.CURRENT))) {
                ModelVersion version = model.getVersion();
                TransformationDescription.Tools.register((TransformationDescription)JGroupsSubsystemResourceDefinition.buildTransformers(version), (SubsystemRegistration)registration, (ModelVersionRange)version);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (JGroupsSchema schema : JGroupsSchema.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new JGroupsSubsystemXMLReader(schema));
        }
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (org.jgroups.logging.LogFactory.getCustomLogFactory() == null) {
                    org.jgroups.logging.LogFactory.setCustomLogFactory((CustomLogFactory)new LogFactory());
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

