/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.Lucene43TypeTokenFilter;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean useWhitelist;
    private final String stopTypesFiles;
    private Set<String> stopTypes;
    private boolean enablePositionIncrements;

    public TypeTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.stopTypesFiles = this.require(args, "types");
        this.useWhitelist = this.getBoolean(args, "useWhitelist", false);
        if (!this.luceneMatchVersion.onOrAfter(Version.LUCENE_5_0_0)) {
            boolean defaultValue = this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0);
            this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", defaultValue);
            if (!this.enablePositionIncrements && this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0)) {
                throw new IllegalArgumentException("enablePositionIncrements=false is not supported anymore as of Lucene 4.4");
            }
        } else if (args.containsKey("enablePositionIncrements")) {
            throw new IllegalArgumentException("enablePositionIncrements is not a valid option as of Lucene 5.0");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files = this.splitFileNames(this.stopTypesFiles);
        if (files.size() > 0) {
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List<String> typesLines = this.getLines(loader, file.trim());
                this.stopTypes.addAll(typesLines);
            }
        }
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0)) {
            return new TypeTokenFilter(input, this.stopTypes, this.useWhitelist);
        }
        Lucene43TypeTokenFilter filter = new Lucene43TypeTokenFilter(this.enablePositionIncrements, input, this.stopTypes, this.useWhitelist);
        return filter;
    }
}

