/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;

public class EncryptableSubsystemHelper {
    private EncryptableSubsystemHelper() {
    }

    static void processEncryption(ModelNode config, EncryptableService service, ServiceBuilder<?> builder) {
        if (config.hasDefined("encryption") && config.get(new String[]{"encryption", "ENCRYPTION"}).isDefined()) {
            EndpointUtils.addSecurityRealmDependency(builder, config.get(new String[]{"encryption", "ENCRYPTION", "security-realm"}).asString(), service.getEncryptionSecurityRealm());
            config = config.get(new String[]{"encryption", "ENCRYPTION"});
            if (config.get("sni").isDefined()) {
                for (ModelNode sniConfiguration : config.get("sni").asList()) {
                    if (!sniConfiguration.get(0).hasDefined("security-realm")) continue;
                    String sniHostName = sniConfiguration.get(0).get("host-name").asString();
                    String securityRealm = sniConfiguration.get(0).get("security-realm").asString();
                    EndpointUtils.addSecurityRealmDependency(builder, securityRealm, service.getSniSecurityRealm(sniHostName));
                }
            }
            if (config.hasDefined("require-ssl-client-auth")) {
                service.setClientAuth(config.get("require-ssl-client-auth").asBoolean());
            }
        }
    }
}

