/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EncryptableServiceHelper;
import org.infinispan.server.endpoint.subsystem.EndpointServerAuthenticationProvider;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.infinispan.server.endpoint.subsystem.SecurityActions;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ProtocolServerService
implements Service<ProtocolServer>,
EncryptableService {
    private final InjectedValue<EmbeddedCacheManager> cacheManager = new InjectedValue();
    private final InjectedValue<GlobalConfiguration> cacheManagerConfiguration = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final InjectedValue<SecurityRealm> authenticationSecurityRealm = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> saslSecurityDomain = new InjectedValue();
    private final InjectedValue<SecurityRealm> encryptionSecurityRealm = new InjectedValue();
    private final Map<String, InjectedValue<SecurityRealm>> sniDomains = new HashMap<String, InjectedValue<SecurityRealm>>();
    private final InjectedValue<ExtensionManagerService> extensionManager = new InjectedValue();
    private final ProtocolServerConfigurationBuilder<?, ?> configurationBuilder;
    private final Class<? extends ProtocolServer> serverClass;
    private ProtocolServer protocolServer;
    private Transport transport;
    private final String serverName;
    private LoginContext serverLoginContext = null;
    private String serverContextName;
    private String defaultCacheName;
    private boolean clientAuth;

    ProtocolServerService(String serverName, Class<? extends ProtocolServer> serverClass, ProtocolServerConfigurationBuilder<?, ?> configurationBuilder) {
        this(serverName, serverClass, configurationBuilder, null);
    }

    ProtocolServerService(String serverName, Class<? extends ProtocolServer> serverClass, ProtocolServerConfigurationBuilder<?, ?> configurationBuilder, String defaultCacheName) {
        this.configurationBuilder = configurationBuilder;
        this.serverClass = serverClass;
        String serverTypeName = serverClass.getSimpleName();
        this.serverName = serverName != null ? serverTypeName + " " + serverName : serverTypeName;
        this.defaultCacheName = defaultCacheName;
    }

    public synchronized void start(StartContext context) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting(this.serverName);
        boolean done = false;
        try {
            String qual;
            InetSocketAddress address;
            if (this.defaultCacheName != null) {
                this.configurationBuilder.defaultCacheName(this.defaultCacheName);
            } else {
                this.configurationBuilder.defaultCacheName(((DefaultCacheContainer)this.cacheManager.getValue()).getDefaultCacheName());
            }
            InetSocketAddress inetSocketAddress = address = this.socketBinding.getOptionalValue() != null ? ((SocketBinding)this.socketBinding.getValue()).getSocketAddress() : null;
            if (address != null) {
                this.configurationBuilder.host(address.getAddress().getHostAddress());
                this.configurationBuilder.port(address.getPort());
            } else {
                this.configurationBuilder.startTransport(false);
                EndpointLogger.ROOT_LOGGER.startingServerWithoutTransport(this.serverName);
            }
            SecurityRealm encryptionRealm = (SecurityRealm)this.encryptionSecurityRealm.getOptionalValue();
            if (encryptionRealm != null) {
                EncryptableServiceHelper.fillSecurityConfiguration(this, this.configurationBuilder.ssl());
                qual = this.isSniEnabled() ? " (SSL+SNI)" : " (SSL)";
            } else {
                qual = "";
            }
            if (this.configurationBuilder instanceof HotRodServerConfigurationBuilder) {
                SecurityRealm authenticationRealm;
                HotRodServerConfigurationBuilder hotRodBuilder = (HotRodServerConfigurationBuilder)this.configurationBuilder;
                if (this.serverContextName != null) {
                    hotRodBuilder.authentication().serverSubject(this.getServerSubject(this.serverContextName));
                }
                if ((authenticationRealm = (SecurityRealm)this.authenticationSecurityRealm.getOptionalValue()) != null) {
                    hotRodBuilder.authentication().serverAuthenticationProvider((ServerAuthenticationProvider)new EndpointServerAuthenticationProvider(authenticationRealm));
                }
            }
            EndpointLogger.ROOT_LOGGER.endpointStarted(this.serverName + qual, address != null ? NetworkUtils.formatAddress((InetSocketAddress)address) : "None");
            this.startProtocolServer(this.configurationBuilder.build());
            this.addToExtensionManagerIfHotRod();
            done = true;
        }
        catch (StartException e) {
            throw e;
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedStart(e, this.serverName);
        }
        finally {
            if (!done) {
                this.doStop();
            }
        }
    }

    private boolean isSniEnabled() {
        return !this.sniDomains.isEmpty();
    }

    private void addToExtensionManagerIfHotRod() {
        if (this.protocolServer instanceof HotRodServer) {
            ((ExtensionManagerService)this.extensionManager.getValue()).addHotRodServer((HotRodServer)this.protocolServer);
        }
    }

    private void removeFromExtensionManagerIfHotRod() {
        if (this.protocolServer instanceof HotRodServer) {
            ((ExtensionManagerService)this.extensionManager.getValue()).removeHotRodServer((HotRodServer)this.protocolServer);
        }
    }

    private void startProtocolServer(ProtocolServerConfiguration configuration) throws StartException {
        ProtocolServer server;
        try {
            server = this.serverClass.newInstance();
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedConnectorInstantiation(e, this.serverName);
        }
        EndpointLogger.ROOT_LOGGER.connectorStarting(this.serverName);
        configuration.ignoredCaches().forEach(arg_0 -> ((ProtocolServer)server).ignoreCache(arg_0));
        SecurityActions.startProtocolServer(server, configuration, (EmbeddedCacheManager)this.getCacheManager().getValue());
        this.protocolServer = server;
        try {
            this.transport = (Transport)ReflectionUtil.getValue((Object)this.protocolServer, (String)"transport");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedTransportInstantiation(e.getCause(), this.serverName);
        }
    }

    public synchronized void stop(StopContext context) {
        this.doStop();
    }

    private void doStop() {
        try {
            if (this.protocolServer != null) {
                EndpointLogger.ROOT_LOGGER.connectorStopping(this.serverName);
                this.removeFromExtensionManagerIfHotRod();
                try {
                    this.protocolServer.stop();
                }
                catch (Exception e) {
                    EndpointLogger.ROOT_LOGGER.connectorStopFailed(e, this.serverName);
                }
            }
            if (this.serverLoginContext != null) {
                try {
                    this.serverLoginContext.logout();
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
            }
        }
        finally {
            EndpointLogger.ROOT_LOGGER.connectorStopped(this.serverName);
        }
    }

    public synchronized ProtocolServer getValue() throws IllegalStateException {
        if (this.protocolServer == null) {
            throw new IllegalStateException();
        }
        return this.protocolServer;
    }

    public InjectedValue<GlobalConfiguration> getCacheManagerConfiguration() {
        return this.cacheManagerConfiguration;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManager;
    }

    public InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }

    public InjectedValue<SecurityRealm> getAuthenticationSecurityRealm() {
        return this.authenticationSecurityRealm;
    }

    public InjectedValue<SecurityDomainContext> getSaslSecurityDomain() {
        return this.saslSecurityDomain;
    }

    @Override
    public InjectedValue<SecurityRealm> getEncryptionSecurityRealm() {
        return this.encryptionSecurityRealm;
    }

    public InjectedValue<ExtensionManagerService> getExtensionManager() {
        return this.extensionManager;
    }

    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public InjectedValue<SecurityRealm> getSniSecurityRealm(String sniHostName) {
        return this.sniDomains.computeIfAbsent(sniHostName, v -> new InjectedValue());
    }

    @Override
    public Map<String, InjectedValue<SecurityRealm>> getSniConfiguration() {
        return this.sniDomains;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setClientAuth(boolean enabled) {
        this.clientAuth = enabled;
    }

    @Override
    public boolean getClientAuth() {
        return this.clientAuth;
    }

    Subject getServerSubject(String serverSecurityDomain) throws LoginException {
        LoginContext lc = new LoginContext(serverSecurityDomain);
        lc.login();
        this.serverLoginContext = lc;
        Subject serverSubject = this.serverLoginContext.getSubject();
        return serverSubject;
    }

    void setServerContextName(String serverContextName) {
        this.serverContextName = serverContextName;
    }
}

