/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.logging;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.util.logging.Log {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error in suspending transaction", id=15001)
    public void errorSuspendingTransaction(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to start transaction", id=15002)
    public void unableToStartTransaction(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to commit work done", id=15003)
    public void unableToCommitTransaction(@Cause Exception var1);

    @Message(value="Unexpected format of key in String form: '%s'", id=15004)
    public IllegalArgumentException keyMappperUnexpectedStringFormat(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Lucene CacheLoader is ignoring key '%s'", id=15005)
    public void cacheLoaderIgnoringKey(Object var1);

    @Message(value="The LuceneCacheLoader requires a directory; invalid path '%s'", id=15006)
    public CacheException rootDirectoryIsNotADirectory(String var1);

    @Message(value="LuceneCacheLoader was unable to create the root directory at path '%s'", id=15007)
    public CacheException unableToCreateDirectory(String var1);

    @Message(value="IOException happened in the CacheLoader", id=15008)
    public PersistenceException exceptionInCacheLoader(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to close FSDirectory", id=15009)
    public void errorOnFSDirectoryClose(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error happened while looking for FSDirectories in '%s'", id=15010)
    public void couldNotWalkDirectory(String var1, @Cause PersistenceException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The configured autoChunkSize is too small for segment file %s as it is %d bytes; auto-scaling chunk size to %d", id=15011)
    public void rescalingChunksize(String var1, long var2, int var4);

    @Message(value="Lucene Directory for index '%s' can not use Cache '%s': maximum lifespan enabled on the Cache configuration!", id=15014)
    public IllegalArgumentException luceneStorageHavingLifespanSet(String var1, String var2);

    @Message(value="Lucene Directory for index '%s' can not use Cache '%s': expiration idle time enabled on the Cache configuration!", id=15015)
    public IllegalArgumentException luceneStorageHavingIdleTimeSet(String var1, String var2);

    @Message(value="'%s' must not be null", id=15016)
    public IllegalArgumentException requiredParameterWasPassedNull(String var1);

    @Message(value="Lucene Directory for index '%s' can not use Cache '%s': store as binary enabled on the Cache configuration!", id=15017)
    public IllegalArgumentException luceneStorageAsBinaryEnabled(String var1, String var2);

    @Message(value="Lucene Directory for index '%s' can not use Metadata Cache '%s': eviction enabled on the Cache configuration!", id=15018)
    public IllegalArgumentException evictionNotAllowedInMetadataCache(String var1, String var2);

    @Message(value="Lucene Directory for index '%s' can not use Metadata Cache '%s': persistence enabled without preload on the Cache configuration!", id=15019)
    public IllegalArgumentException preloadNeededIfPersistenceIsEnabledForMetadataCache(String var1, String var2);

    @Message(value="Lucene Directory for index '%s' can not use Cache '%s': fetch in state is not enabled in Cache configuration!", id=15020)
    public IllegalArgumentException luceneStorageNoStateTransferEnabled(String var1, String var2);

    @Message(value="Lucene Directory for index '%s' can not set affinity location to segment id '%d': must be a positive integer!", id=15021)
    public IllegalArgumentException affinityLocationIntoSegmentValueShallNotBeNegative(String var1, int var2);
}

