/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.impl.Operation;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public class RemoveOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;

    public RemoveOperation() {
    }

    RemoveOperation(K key, V oldValue) {
        this.key = key;
        this.oldValue = oldValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue != null) {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.remove(this.key);
    }

    @Override
    public K keyAffected() {
        return this.key;
    }

    public String toString() {
        return "RemoveOperation{key=" + this.key + ", oldValue=" + this.oldValue + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<RemoveOperation> {
        public void writeObject(ObjectOutput output, RemoveOperation remove) throws IOException {
            output.writeObject(remove.key);
        }

        public RemoveOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            RemoveOperation remove = new RemoveOperation();
            remove.key = input.readObject();
            return remove;
        }

        public Integer getId() {
            return 25;
        }

        public Set<Class<? extends RemoveOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RemoveOperation.class});
        }
    }
}

