/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class PrimaryMultiKeyAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 31;
    private static final Type[] CACHED_TYPE = Type.values();
    private long id;
    private Map<Object, Object> returnValue = null;
    private Type type;
    private CommandAckCollector commandAckCollector;
    private int topologyId;

    public PrimaryMultiKeyAckCommand() {
        super(null);
    }

    public PrimaryMultiKeyAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public PrimaryMultiKeyAckCommand(ByteString cacheName, long id, int topologyId) {
        super(cacheName);
        this.id = id;
        this.topologyId = topologyId;
    }

    private static Type valueOf(int index) {
        return CACHED_TYPE[index];
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.commandAckCollector.multiKeyPrimaryAck(this.id, this.getOrigin(), this.returnValue, this.topologyId);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 31;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        MarshallUtil.marshallEnum((Enum)this.type, (ObjectOutput)output);
        output.writeInt(this.topologyId);
        if (this.type == Type.SUCCESS_WITH_RETURN_VALUE) {
            MarshallUtil.marshallMap(this.returnValue, (ObjectOutput)output);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.type = (Type)MarshallUtil.unmarshallEnum((ObjectInput)input, PrimaryMultiKeyAckCommand::valueOf);
        this.topologyId = input.readInt();
        assert (this.type != null);
        if (this.type == Type.SUCCESS_WITH_RETURN_VALUE) {
            this.returnValue = MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
        }
    }

    public void initWithReturnValue(Map<Object, Object> returnValue) {
        this.returnValue = returnValue;
        this.type = Type.SUCCESS_WITH_RETURN_VALUE;
    }

    public void initWithoutReturnValue() {
        this.type = Type.SUCCESS_WITHOUT_RETURN_VALUE;
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    @Override
    public String toString() {
        return "PrimaryMultiKeyAckCommand{id=" + this.id + ", returnValue=" + this.returnValue + ", type=" + (Object)((Object)this.type) + ", topologyId=" + this.topologyId + '}';
    }

    private static enum Type {
        SUCCESS_WITH_RETURN_VALUE,
        SUCCESS_WITHOUT_RETURN_VALUE;

    }
}

