/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleOrderAction
implements Action {
    private static final Log log = LogFactory.getLog(TriangleOrderAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final TriangleOrderManager triangleOrderManager;
    private final BlockingTaskAwareExecutorService remoteExecutorService;
    private final ClusteringDependentLogic clusteringDependentLogic;
    private final Object key;
    private final long sequenceNumber;
    private volatile int segmentId = -1;

    public TriangleOrderAction(TriangleOrderManager triangleOrderManager, BlockingTaskAwareExecutorService remoteExecutorService, ClusteringDependentLogic clusteringDependentLogic, long sequenceNumber, Object key) {
        this.triangleOrderManager = triangleOrderManager;
        this.remoteExecutorService = remoteExecutorService;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.sequenceNumber = sequenceNumber;
        this.key = key;
    }

    @Override
    public ActionStatus check(ActionState state) {
        int localSegmentId = this.computeSegmentIdIfNeeded();
        if (trace) {
            log.tracef("Checking if next for segment %s and sequence %s", localSegmentId, this.sequenceNumber);
        }
        return this.triangleOrderManager.isNext(localSegmentId, this.sequenceNumber, state.getCommandTopologyId()) ? ActionStatus.READY : ActionStatus.NOT_READY;
    }

    @Override
    public void onFinally(ActionState state) {
        this.triangleOrderManager.markDelivered(this.computeSegmentIdIfNeeded(), this.sequenceNumber, state.getCommandTopologyId());
        this.remoteExecutorService.checkForReadyTasks();
    }

    private int computeSegmentIdIfNeeded() {
        int tmp = this.segmentId;
        if (tmp == -1) {
            this.segmentId = tmp = this.clusteringDependentLogic.getSegmentForKey(this.key);
        }
        return tmp;
    }
}

