/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int TOPOLOGY_ID_STOPPED = Integer.MAX_VALUE;
    private final ReadWriteLock ownershipLock = new ReentrantReadWriteLock();
    private volatile int topologyId = -1;
    private CompletableFuture<Void> topologyFuture = new CompletableFuture();
    private volatile int transactionDataTopologyId = -1;
    private CompletableFuture<Void> transactionDataFuture = new CompletableFuture();

    public void stop() {
        this.notifyTransactionDataReceived(Integer.MAX_VALUE);
        this.notifyTopologyInstalled(Integer.MAX_VALUE);
    }

    @Override
    public void acquireExclusiveTopologyLock() {
        this.ownershipLock.writeLock().lock();
    }

    @Override
    public void releaseExclusiveTopologyLock() {
        this.ownershipLock.writeLock().unlock();
    }

    @Override
    public void acquireSharedTopologyLock() {
        this.ownershipLock.readLock().lock();
    }

    @Override
    public void releaseSharedTopologyLock() {
        this.ownershipLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionDataReceived(int topologyId) {
        if (topologyId < this.transactionDataTopologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.transactionDataTopologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling transaction data received for topology %d", topologyId);
        }
        this.transactionDataTopologyId = topologyId;
        CompletableFuture<Void> oldFuture = null;
        try {
            StateTransferLockImpl stateTransferLockImpl = this;
            synchronized (stateTransferLockImpl) {
                oldFuture = this.transactionDataFuture;
                this.transactionDataFuture = new CompletableFuture();
            }
        }
        finally {
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> transactionDataFuture(int expectedTopologyId) {
        if (this.transactionDataTopologyId >= expectedTopologyId) {
            return CompletableFutures.completedNull();
        }
        if (trace) {
            log.tracef("Waiting for transaction data for topology %d, current topology is %d", expectedTopologyId, this.transactionDataTopologyId);
        }
        StateTransferLockImpl stateTransferLockImpl = this;
        synchronized (stateTransferLockImpl) {
            if (this.transactionDataTopologyId >= expectedTopologyId) {
                return CompletableFutures.completedNull();
            }
            return this.transactionDataFuture.thenCompose(nil -> this.transactionDataFuture(expectedTopologyId));
        }
    }

    @Override
    public boolean transactionDataReceived(int expectedTopologyId) {
        if (trace) {
            log.tracef("Checking if transaction data was received for topology %s, current topology is %s", expectedTopologyId, this.transactionDataTopologyId);
        }
        return this.transactionDataTopologyId >= expectedTopologyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTopologyInstalled(int topologyId) {
        if (topologyId < this.topologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.topologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling topology %d is installed", topologyId);
        }
        this.topologyId = topologyId;
        CompletableFuture<Void> oldFuture = null;
        try {
            StateTransferLockImpl stateTransferLockImpl = this;
            synchronized (stateTransferLockImpl) {
                oldFuture = this.topologyFuture;
                this.topologyFuture = new CompletableFuture();
            }
        }
        finally {
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> topologyFuture(int expectedTopologyId) {
        if (this.topologyId >= expectedTopologyId) {
            return CompletableFutures.completedNull();
        }
        if (trace) {
            log.tracef("Waiting for topology %d to be installed, current topology is %d", expectedTopologyId, this.topologyId);
        }
        StateTransferLockImpl stateTransferLockImpl = this;
        synchronized (stateTransferLockImpl) {
            if (this.topologyId >= expectedTopologyId) {
                return CompletableFutures.completedNull();
            }
            return this.topologyFuture.thenCompose(nil -> this.topologyFuture(expectedTopologyId));
        }
    }

    @Override
    public boolean topologyReceived(int expectedTopologyId) {
        return this.topologyId >= expectedTopologyId;
    }
}

