/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentHashMap<Long, Collector<?>> collectorMap = new ConcurrentHashMap();
    private ScheduledExecutorService timeoutExecutor;
    private long timeoutNanoSeconds;

    private static TimeoutException createTimeoutException(long timeoutNanoSeconds, long id) {
        return log.timeoutWaitingForAcks(Util.prettyPrintTime((long)timeoutNanoSeconds, (TimeUnit)TimeUnit.NANOSECONDS), id);
    }

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, Configuration configuration) {
        this.timeoutExecutor = timeoutExecutor;
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(configuration.clustering().remoteTimeout());
    }

    public void create(long id, Collection<Address> owners, int topologyId) {
        SingleKeyCollector collector = new SingleKeyCollector(id, owners, topologyId);
        collector.setCleanupTask();
        this.collectorMap.put(id, collector);
        if (trace) {
            log.tracef("Created new collector for %s. Owners=%s", id, owners);
        }
    }

    public void create(long id, Object returnValue, Address primaryOwner, Collection<Address> backupOwners, int topologyId) {
        SingleKeyCollector collector = new SingleKeyCollector(id, returnValue, primaryOwner, backupOwners, topologyId);
        collector.setCleanupTask();
        this.collectorMap.put(id, collector);
        if (trace) {
            log.tracef("Created new collector for %s. ReturnValue=%s. Owners=%s", id, returnValue, backupOwners);
        }
    }

    public void createMultiKeyCollector(long id, Collection<Address> primary, Map<Address, Collection<Integer>> backups, int topologyId) {
        MultiKeyCollector collector = new MultiKeyCollector(id, primary, backups, topologyId);
        collector.setCleanupTask();
        this.collectorMap.put(id, collector);
        if (trace) {
            log.tracef("Created new collector for %s. Primary=%s. BackupSegments=%s", id, primary, backups);
        }
    }

    public void multiKeyPrimaryAck(long id, Address from, Map<Object, Object> returnValue, int topologyId) {
        MultiKeyCollector collector = (MultiKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.primaryAck(returnValue, from, topologyId);
        }
    }

    public void multiKeyBackupAck(long id, Address from, int segment, int topologyId) {
        MultiKeyCollector collector = (MultiKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void backupAck(long id, Address from, int topologyId) {
        SingleKeyCollector collector = (SingleKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(topologyId, from);
        }
    }

    public void primaryAck(long id, Object returnValue, boolean success, Address from, int topologyId) {
        SingleKeyCollector collector = (SingleKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.primaryAck(topologyId, returnValue, success, from);
        }
    }

    public void completeExceptionally(long id, Throwable throwable, int topologyId) {
        Collector<?> collector = this.collectorMap.get(id);
        if (collector != null) {
            collector.completeExceptionally(throwable, topologyId);
        }
    }

    public <T> CompletableFuture<T> getCollectorCompletableFuture(long id) {
        Collector<?> collector = this.collectorMap.get(id);
        return collector == null ? null : collector.getFuture();
    }

    public <T> CompletableFuture<T> getCollectorCompletableFutureToWait(long id) {
        Collector<?> collector = this.collectorMap.get(id);
        if (trace) {
            log.tracef("[Collector#%s] Waiting for acks asynchronously.", id);
        }
        return collector == null ? null : collector.addCleanupTasksAndGetFuture();
    }

    public List<Long> getPendingCommands() {
        return new ArrayList<Long>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(long id) {
        Collector<?> collector = this.collectorMap.get(id);
        return collector != null && collector.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        for (Collector<?> collector : this.collectorMap.values()) {
            collector.onMembersChange(currentMembers);
        }
    }

    public void dispose(long id) {
        if (trace) {
            log.tracef("[Collector#%s] Dispose collector.", id);
        }
        this.collectorMap.remove(id);
    }

    private class MultiKeyCollector
    extends Collector<Map<Object, Object>> {
        @GuardedBy(value="this")
        private final HashSet<Address> primary;
        @GuardedBy(value="this")
        private final HashMap<Address, Collection<Integer>> backups;
        @GuardedBy(value="this")
        private HashMap<Object, Object> returnValue;

        MultiKeyCollector(long id, Collection<Address> primary, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.returnValue = null;
            this.backups = new HashMap<Address, Collection<Integer>>(backups);
            this.primary = new HashSet<Address>(primary);
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public void onMembersChange(Collection<Address> members) {
            if (this.hasSomePrimaryLeft(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] A primary Owner left the cluster.", this.id);
                }
                this.doCompleteExceptionally((Throwable)((Object)OutdatedTopologyException.getCachedInstance()));
            } else if (this.hasSomeBackupLeft(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void primaryAck(Map<Object, Object> returnValue, Address from, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Primary ACK. Address=%s. TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            MultiKeyCollector multiKeyCollector = this;
            synchronized (multiKeyCollector) {
                if (returnValue != null) {
                    if (this.returnValue == null) {
                        this.returnValue = new HashMap(returnValue.size());
                    }
                    this.returnValue.putAll(returnValue);
                }
                if (this.primary.remove(from)) {
                    this.checkCompleted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(Address from, int segment, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", new Object[]{this.id, from, topologyId, this.topologyId, segment});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            MultiKeyCollector multiKeyCollector = this;
            synchronized (multiKeyCollector) {
                Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
                if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                    this.backups.remove(from);
                }
                this.checkCompleted();
            }
        }

        @Override
        void doCompleteExceptionally(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        private synchronized boolean hasSomePrimaryLeft(Collection<Address> members) {
            return !members.containsAll(this.primary);
        }

        private synchronized boolean hasSomeBackupLeft(Collection<Address> members) {
            return this.backups.keySet().retainAll(members);
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primary.isEmpty() && this.backups.isEmpty()) {
                if (trace) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.returnValue);
                }
                this.future.complete(this.returnValue);
            }
        }
    }

    private class SingleKeyCollector
    extends Collector<Object> {
        @GuardedBy(value="owners")
        private final HashSet<Address> owners;
        private final Address primaryOwner;
        private volatile Object returnValue;

        private SingleKeyCollector(long id, Collection<Address> owners, int topologyId) {
            super(id, topologyId);
            this.primaryOwner = owners.iterator().next();
            this.owners = new HashSet<Address>(owners);
        }

        private SingleKeyCollector(long id, Object returnValue, Address primaryOwner, Collection<Address> owners, int topologyId) {
            super(id, topologyId);
            this.returnValue = returnValue;
            this.primaryOwner = primaryOwner;
            this.owners = new HashSet<Address>(owners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPendingBackupAcks() {
            HashSet<Address> hashSet = this.owners;
            synchronized (hashSet) {
                return this.owners.size() > 1 || this.owners.size() == 1 && !this.owners.iterator().next().equals(this.primaryOwner);
            }
        }

        @Override
        public void onMembersChange(Collection<Address> members) {
            if (!members.contains(this.primaryOwner)) {
                if (trace) {
                    log.tracef("[Collector#%s] The Primary Owner left the cluster.", this.id);
                }
                this.doCompleteExceptionally((Throwable)((Object)OutdatedTopologyException.getCachedInstance()));
            } else if (this.haveAllBackupsLeft(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        void primaryAck(int topologyId, Object returnValue, boolean success, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] Primary ACK. Success=%s. ReturnValue=%s. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, success, returnValue, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            if (this.checkPrimaryAck(returnValue, from) || !success) {
                this.markReady();
            }
        }

        void backupAck(int topologyId, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            if (this.removeBackupOwner(from)) {
                this.markReady();
            }
        }

        @Override
        void doCompleteExceptionally(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkPrimaryAck(Object returnValue, Address from) {
            HashSet<Address> hashSet = this.owners;
            synchronized (hashSet) {
                if (this.owners.remove(from)) {
                    this.returnValue = returnValue;
                    return this.owners.isEmpty();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean haveAllBackupsLeft(Collection<Address> members) {
            HashSet<Address> hashSet = this.owners;
            synchronized (hashSet) {
                return this.owners.retainAll(members) && this.owners.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeBackupOwner(Address member) {
            HashSet<Address> hashSet = this.owners;
            synchronized (hashSet) {
                return this.owners.remove(member) && this.owners.isEmpty();
            }
        }

        private void markReady() {
            if (trace) {
                log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.returnValue);
            }
            this.future.complete(this.returnValue);
        }
    }

    private abstract class Collector<T>
    implements BiConsumer<T, Throwable> {
        final long id;
        final CompletableFuture<T> future;
        final int topologyId;
        private volatile ScheduledFuture<?> timeoutTask;

        Collector(long id, int topologyId) {
            this.id = id;
            this.topologyId = topologyId;
            this.future = new CompletableFuture();
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            CommandAckCollector.this.collectorMap.remove(this.id);
            this.timeoutTask.cancel(false);
        }

        final void completeExceptionally(Throwable throwable, int topologyId) {
            if (trace) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, topologyId, this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            this.doCompleteExceptionally(throwable);
        }

        abstract boolean hasPendingBackupAcks();

        final CompletableFuture<T> getFuture() {
            return this.future;
        }

        abstract void onMembersChange(Collection<Address> var1);

        abstract void doCompleteExceptionally(Throwable var1);

        final CompletableFuture<T> addCleanupTasksAndGetFuture() {
            if (this.future.isDone()) {
                CommandAckCollector.this.collectorMap.remove(this.id);
                return this.future;
            }
            return this.future.whenComplete((BiConsumer)this);
        }

        final void setCleanupTask() {
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(() -> this.doCompleteExceptionally((Throwable)((Object)CommandAckCollector.createTimeoutException(CommandAckCollector.this.timeoutNanoSeconds, this.id))), CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
        }

        final boolean isWrongTopologyOrIsDone(int topologyId) {
            return this.topologyId != topologyId || this.future.isDone();
        }
    }
}

