/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.AlternativeAttributeValidationStepHandler;
import org.wildfly.extension.picketlink.common.model.validator.ElementMaxOccurrenceValidationStepHandler;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderAddHandler;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;

public class IdentityProviderConfigAddStepHandler
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;
    private final List<AttributeDefinition> alternativeAttributes = new ArrayList<AttributeDefinition>();

    IdentityProviderConfigAddStepHandler(AttributeDefinition ... attributes) {
        super(ModelElement.IDENTITY_PROVIDER.getName());
        for (AttributeDefinition attribute : this.attributes = attributes != null ? attributes : new AttributeDefinition[]{}) {
            if (attribute.getAlternatives() == null || attribute.getAlternatives().length <= 0) continue;
            this.alternativeAttributes.add(attribute);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep((OperationStepHandler)new ElementMaxOccurrenceValidationStepHandler(ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER, ModelElement.IDENTITY_PROVIDER, 1), OperationContext.Stage.MODEL);
        context.addStep((OperationStepHandler)new ElementMaxOccurrenceValidationStepHandler(ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR, ModelElement.IDENTITY_PROVIDER, 1), OperationContext.Stage.MODEL);
        if (!this.alternativeAttributes.isEmpty()) {
            context.addStep((OperationStepHandler)new AlternativeAttributeValidationStepHandler(this.alternativeAttributes.toArray(new AttributeDefinition[this.alternativeAttributes.size()])), OperationContext.Stage.MODEL);
        }
        super.execute(context, operation);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        IdentityProviderAddHandler.launchServices(context, parentModel, verificationHandler, null, parentAddress, true);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        IdentityProviderAddHandler.launchServices(context, parentModel, null, null, parentAddress, true);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return IdentityProviderService.createServiceName(parentAddress.getLastElement().getValue());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }
}

