/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class DefaultRemoveStepHandler
extends RestartParentResourceRemoveHandler {
    static final DefaultRemoveStepHandler INSTANCE = new DefaultRemoveStepHandler();

    private DefaultRemoveStepHandler() {
        super(ModelElement.PARTITION_MANAGER.getName());
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        super.updateModel(context, operation);
        PathAddress partitionManagerAddress = this.getParentAddress(PathAddress.pathAddress((ModelNode)operation.require("address")));
        Resource partitionManagerResource = context.readResourceFromRoot(partitionManagerAddress);
        ModelNode parentModel = Resource.Tools.readModel((Resource)partitionManagerResource);
        PartitionManagerAddHandler.INSTANCE.validateModel(context, partitionManagerAddress.getLastElement().getValue(), parentModel);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, false);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }
}

