/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public final class MarshallerUtil {
    private static final Log log = LogFactory.getLog(MarshallerUtil.class, Log.class);

    private MarshallerUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T bytes2obj(Marshaller marshaller, byte[] bytes, short status) {
        if (bytes == null) return null;
        if (bytes.length == 0) {
            return null;
        }
        try {
            Object ret = marshaller.objectFromByteBuffer(bytes);
            if (!HotRodConstants.hasCompatibility(status)) return (T)ret;
            if (!(ret instanceof byte[])) return (T)ret;
            if (!MarshallerUtil.isJavaSerialized((byte[])ret)) return (T)ret;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])ret));){
                Object object = ois.readObject();
                return (T)object;
            }
            catch (Exception ee) {
                if (!log.isDebugEnabled()) return (T)ret;
                log.debugf("Standard deserialization not in use for %s", Util.printArray((byte[])bytes));
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw log.unableToUnmarshallBytes(Util.toHexString((byte[])bytes), e);
        }
    }

    private static boolean isJavaSerialized(byte[] bytes) {
        if (bytes.length > 2) {
            short magic = (short)((bytes[1] & 0xFF) + (bytes[0] << 8));
            return magic == -21267;
        }
        return false;
    }

    static short getShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static byte[] obj2bytes(Marshaller marshaller, Object o, boolean isKey, int estimateKeySize, int estimateValueSize) {
        try {
            return marshaller.objectToByteBuffer(o, isKey ? estimateKeySize : estimateValueSize);
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

