/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionRegistryBuilder;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalyzerDefinitionContextImpl;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneAnalyzerDefinitionRegistryBuilderImpl
implements LuceneAnalyzerDefinitionRegistryBuilder {
    private static final Log LOG = LoggerFactory.make();
    private Map<String, LuceneAnalyzerDefinitionContextImpl> definitions = new LinkedHashMap<String, LuceneAnalyzerDefinitionContextImpl>();

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(String name) {
        LuceneAnalyzerDefinitionContextImpl definition = new LuceneAnalyzerDefinitionContextImpl(this, name);
        LuceneAnalyzerDefinitionContextImpl existing = this.definitions.putIfAbsent(name, definition);
        if (existing != null) {
            throw LOG.analyzerDefinitionNamingConflict(name);
        }
        return definition;
    }

    public Map<String, AnalyzerDef> build() {
        LinkedHashMap<String, AnalyzerDef> result = new LinkedHashMap<String, AnalyzerDef>();
        for (Map.Entry<String, LuceneAnalyzerDefinitionContextImpl> entry : this.definitions.entrySet()) {
            result.put(entry.getKey(), entry.getValue().build());
        }
        return result;
    }
}

