/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.Activation;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.TransactionSupport;
import javax.validation.constraints.NotNull;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.annotations.SecurityActions;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.spec.Icon;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.spec.ActivationSpecImpl;
import org.jboss.jca.common.metadata.spec.AdminObjectImpl;
import org.jboss.jca.common.metadata.spec.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.ConnectorImpl;
import org.jboss.jca.common.metadata.spec.IconImpl;
import org.jboss.jca.common.metadata.spec.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.LicenseTypeImpl;
import org.jboss.jca.common.metadata.spec.MessageAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageListenerImpl;
import org.jboss.jca.common.metadata.spec.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.RequiredConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.SecurityPermissionImpl;
import org.jboss.jca.common.spi.annotations.repository.Annotation;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class Annotations {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)Annotations.class.getName());

    public org.jboss.jca.common.api.metadata.spec.Connector merge(org.jboss.jca.common.api.metadata.spec.Connector connector, AnnotationRepository annotationRepository, ClassLoader classLoader) throws Exception {
        if (connector == null || connector.getVersion() == Connector.Version.V_16 || connector.getVersion() == Connector.Version.V_17) {
            boolean isMetadataComplete = false;
            if (connector != null) {
                isMetadataComplete = connector.isMetadataComplete();
            }
            if (connector == null || !isMetadataComplete) {
                if (connector == null) {
                    org.jboss.jca.common.api.metadata.spec.Connector annotationsConnector;
                    connector = annotationsConnector = this.process(annotationRepository, null, classLoader);
                } else {
                    org.jboss.jca.common.api.metadata.spec.Connector annotationsConnector = this.process(annotationRepository, connector.getResourceadapter().getResourceadapterClass(), classLoader);
                    connector = (org.jboss.jca.common.api.metadata.spec.Connector)connector.merge((MergeableMetadata)annotationsConnector);
                }
            }
        }
        return connector;
    }

    public org.jboss.jca.common.api.metadata.spec.Connector process(AnnotationRepository annotationRepository, String xmlResourceAdapterClass, ClassLoader classLoader) throws Exception {
        ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> definitions;
        if (annotationRepository == null) {
            throw new ValidateException(bundle.annotationRepositoryNull());
        }
        Map<Metadatas, ArrayList<ConfigProperty>> configPropertiesMap = this.processConfigProperty(annotationRepository, classLoader);
        ArrayList<Object> connectionDefinitions = this.processConnectionDefinitions(annotationRepository, classLoader, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.MANAGED_CONN_FACTORY), configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.PLAIN));
        if (connectionDefinitions == null) {
            connectionDefinitions = new ArrayList(1);
        }
        if ((definitions = this.processConnectionDefinition(annotationRepository, classLoader, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.MANAGED_CONN_FACTORY), configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.PLAIN))) != null) {
            connectionDefinitions.addAll(definitions);
        }
        connectionDefinitions.trimToSize();
        InboundResourceAdapter inboundRA = this.processActivation(annotationRepository, classLoader, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.ACTIVATION_SPEC), configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.PLAIN));
        ArrayList<AdminObject> adminObjs = this.processAdministeredObject(annotationRepository, classLoader, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.ADMIN_OBJECT), configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.PLAIN));
        org.jboss.jca.common.api.metadata.spec.Connector conn = this.processConnector(annotationRepository, classLoader, xmlResourceAdapterClass, connectionDefinitions, configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.RA), configPropertiesMap == null ? null : configPropertiesMap.get((Object)Metadatas.PLAIN), inboundRA, adminObjs);
        return conn;
    }

    private org.jboss.jca.common.api.metadata.spec.Connector processConnector(AnnotationRepository annotationRepository, ClassLoader classLoader, String xmlResourceAdapterClass, ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> connectionDefinitions, ArrayList<ConfigProperty> configProperties, ArrayList<ConfigProperty> plainConfigProperties, InboundResourceAdapter inboundResourceadapter, ArrayList<AdminObject> adminObjs) throws Exception {
        org.jboss.jca.common.api.metadata.spec.Connector connector = null;
        Collection values = annotationRepository.getAnnotation(Connector.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                String raClass = annotation.getClassName();
                Connector connectorAnnotation = (Connector)annotation.getAnnotation();
                log.tracef("Processing: %s for %s", connectorAnnotation, raClass);
                connector = this.attachConnector(raClass, classLoader, connectorAnnotation, connectionDefinitions, configProperties, plainConfigProperties, inboundResourceadapter, adminObjs);
            } else if (values.size() == 0) {
                if (xmlResourceAdapterClass == null || xmlResourceAdapterClass.equals("")) {
                    log.noConnector();
                    throw new ValidateException(bundle.noConnectorDefined());
                }
            } else if (xmlResourceAdapterClass == null || xmlResourceAdapterClass.equals("")) {
                log.moreThanOneConnector();
                throw new ValidateException(bundle.moreThanOneConnectorDefined());
            }
        } else {
            connector = this.attachConnector(xmlResourceAdapterClass, classLoader, null, connectionDefinitions, null, null, inboundResourceadapter, adminObjs);
        }
        return connector;
    }

    private org.jboss.jca.common.api.metadata.spec.Connector attachConnector(String raClass, ClassLoader classLoader, Connector conAnnotation, ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> connectionDefinitions, ArrayList<ConfigProperty> configProperties, ArrayList<ConfigProperty> plainConfigProperties, InboundResourceAdapter inboundResourceadapter, ArrayList<AdminObject> adminObjs) throws Exception {
        XsdString vendorName = null;
        if (conAnnotation != null) {
            vendorName = new XsdString(conAnnotation.vendorName(), null);
        }
        ArrayList<LocalizedXsdString> descriptions = null;
        if (conAnnotation != null && conAnnotation.description() != null && conAnnotation.description().length != 0) {
            descriptions = new ArrayList<LocalizedXsdString>(conAnnotation.description().length);
            for (String descriptionAnnoptation : conAnnotation.description()) {
                descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
            }
        }
        ArrayList<LocalizedXsdString> displayNames = null;
        if (conAnnotation != null && conAnnotation.displayName() != null && conAnnotation.displayName().length != 0) {
            displayNames = new ArrayList<LocalizedXsdString>(conAnnotation.displayName().length);
            for (String displayNameAnnotation : conAnnotation.displayName()) {
                displayNames.add(new LocalizedXsdString(displayNameAnnotation, null));
            }
        }
        XsdString eisType = null;
        if (conAnnotation != null) {
            eisType = new XsdString(conAnnotation.eisType(), null);
        }
        ArrayList<LocalizedXsdString> licenseDescriptions = null;
        if (conAnnotation != null && conAnnotation.licenseDescription() != null && conAnnotation.licenseDescription().length != 0) {
            licenseDescriptions = new ArrayList<LocalizedXsdString>(conAnnotation.licenseDescription().length);
            for (String licenseDescriptionAnnotation : conAnnotation.licenseDescription()) {
                licenseDescriptions.add(new LocalizedXsdString(licenseDescriptionAnnotation, null));
            }
        }
        LicenseTypeImpl license = null;
        if (conAnnotation != null) {
            license = new LicenseTypeImpl(licenseDescriptions, conAnnotation.licenseRequired(), null, null);
        }
        ArrayList<XsdString> requiredWorkContexts = null;
        Class[] requiredWorkContextAnnotations = null;
        if (conAnnotation != null) {
            requiredWorkContextAnnotations = conAnnotation.requiredWorkContexts();
        }
        if (requiredWorkContextAnnotations != null) {
            requiredWorkContexts = new ArrayList<XsdString>(requiredWorkContextAnnotations.length);
            for (Class requiredWorkContext : requiredWorkContextAnnotations) {
                XsdString xs = new XsdString(requiredWorkContext.getName(), null);
                if (requiredWorkContexts.contains(xs)) continue;
                log.tracef("RequiredWorkContext=%s", requiredWorkContext.getName());
                requiredWorkContexts.add(xs);
            }
        }
        ArrayList<Icon> icons = null;
        if (conAnnotation != null && (conAnnotation.smallIcon() != null && conAnnotation.smallIcon().length != 0 || conAnnotation.largeIcon() != null && conAnnotation.largeIcon().length != 0)) {
            icons = new ArrayList<Icon>((conAnnotation.smallIcon() == null ? 0 : conAnnotation.smallIcon().length) + (conAnnotation.largeIcon() == null ? 0 : conAnnotation.largeIcon().length));
            if (conAnnotation.smallIcon() != null && conAnnotation.smallIcon().length > 0) {
                for (String smallIconAnnotation : conAnnotation.smallIcon()) {
                    if (smallIconAnnotation == null || smallIconAnnotation.trim().equals("")) continue;
                    icons.add(new IconImpl(new XsdString(smallIconAnnotation, null), null, null, null));
                }
            }
            if (conAnnotation.largeIcon() != null && conAnnotation.largeIcon().length > 0) {
                for (String largeIconAnnotation : conAnnotation.largeIcon()) {
                    if (largeIconAnnotation == null || largeIconAnnotation.trim().equals("")) continue;
                    icons.add(new IconImpl(null, new XsdString(largeIconAnnotation, null), null, null));
                }
            }
        }
        TransactionSupport.TransactionSupportLevel transactionSupportAnnotation = null;
        TransactionSupportEnum transactionSupport = null;
        if (conAnnotation != null) {
            transactionSupportAnnotation = conAnnotation.transactionSupport();
        }
        if (transactionSupportAnnotation != null) {
            transactionSupport = TransactionSupportEnum.valueOf((String)transactionSupportAnnotation.name());
        }
        boolean reauthenticationSupport = false;
        if (conAnnotation != null) {
            reauthenticationSupport = conAnnotation.reauthenticationSupport();
        }
        ArrayList<AuthenticationMechanism> authenticationMechanisms = null;
        if (conAnnotation != null) {
            authenticationMechanisms = this.processAuthenticationMechanism(conAnnotation.authMechanisms());
        }
        OutboundResourceAdapterImpl outboundResourceadapter = new OutboundResourceAdapterImpl(connectionDefinitions, transactionSupport, authenticationMechanisms, reauthenticationSupport, null, null, null);
        ArrayList<SecurityPermission> securityPermissions = null;
        if (conAnnotation != null) {
            securityPermissions = this.processSecurityPermissions(conAnnotation.securityPermissions());
        }
        ArrayList<ConfigProperty> validProperties = new ArrayList<ConfigProperty>();
        if (configProperties != null) {
            validProperties.addAll(configProperties);
        }
        if (plainConfigProperties != null && raClass != null) {
            Set<String> raClasses = this.getClasses(raClass, classLoader);
            for (ConfigProperty configProperty : plainConfigProperties) {
                if (!raClasses.contains(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                log.tracef("Attaching: %s (%s)", configProperty, raClass);
                validProperties.add(configProperty);
            }
        }
        validProperties.trimToSize();
        ResourceAdapterImpl resourceAdapter = new ResourceAdapterImpl(new XsdString(raClass, null), validProperties, outboundResourceadapter, inboundResourceadapter, adminObjs, securityPermissions, null);
        XsdString resourceadapterVersion = null;
        if (conAnnotation != null && conAnnotation.version() != null && !conAnnotation.version().trim().equals("")) {
            resourceadapterVersion = new XsdString(conAnnotation.version(), null);
        }
        return new ConnectorImpl(Connector.Version.V_17, new XsdString("", null), vendorName, eisType, resourceadapterVersion, license, resourceAdapter, requiredWorkContexts, false, descriptions, displayNames, icons, null);
    }

    private ArrayList<SecurityPermission> processSecurityPermissions(javax.resource.spi.SecurityPermission[] securityPermissionAnotations) {
        ArrayList<SecurityPermissionImpl> securityPermissions = null;
        if (securityPermissionAnotations != null && securityPermissionAnotations.length != 0) {
            securityPermissions = new ArrayList<SecurityPermissionImpl>(securityPermissionAnotations.length);
            for (javax.resource.spi.SecurityPermission securityPermission : securityPermissionAnotations) {
                ArrayList<LocalizedXsdString> desc = null;
                if (securityPermission.description() != null && securityPermission.description().length > 0) {
                    desc = new ArrayList<LocalizedXsdString>(securityPermission.description().length);
                    for (String d : securityPermission.description()) {
                        if (d == null || d.trim().equals("")) continue;
                        desc.add(new LocalizedXsdString(d, null));
                    }
                }
                SecurityPermissionImpl spmd = new SecurityPermissionImpl(desc, new XsdString(securityPermission.permissionSpec(), null), null);
                securityPermissions.add(spmd);
            }
            securityPermissions.trimToSize();
        }
        return securityPermissions;
    }

    private ArrayList<AuthenticationMechanism> processAuthenticationMechanism(javax.resource.spi.AuthenticationMechanism[] authMechanismAnnotations) {
        ArrayList<AuthenticationMechanismImpl> authenticationMechanisms = null;
        if (authMechanismAnnotations != null) {
            authenticationMechanisms = new ArrayList<AuthenticationMechanismImpl>(authMechanismAnnotations.length);
            for (javax.resource.spi.AuthenticationMechanism authMechanismAnnotation : authMechanismAnnotations) {
                ArrayList<LocalizedXsdString> descriptions = null;
                if (authMechanismAnnotation.description() != null && authMechanismAnnotation.description().length != 0) {
                    descriptions = new ArrayList<LocalizedXsdString>(authMechanismAnnotation.description().length);
                    for (String descriptionAnnoptation : authMechanismAnnotation.description()) {
                        descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
                    }
                }
                XsdString authenticationMechanismType = new XsdString(authMechanismAnnotation.authMechanism(), null);
                authenticationMechanisms.add(new AuthenticationMechanismImpl(descriptions, authenticationMechanismType, CredentialInterfaceEnum.valueOf((String)authMechanismAnnotation.credentialInterface().name()), null, null));
            }
        }
        return authenticationMechanisms;
    }

    private ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> processConnectionDefinitions(AnnotationRepository annotationRepository, ClassLoader classLoader, ArrayList<? extends ConfigProperty> configProperties, ArrayList<? extends ConfigProperty> plainConfigProperties) throws Exception {
        Collection values = annotationRepository.getAnnotation(ConnectionDefinitions.class);
        if (values != null) {
            if (values.size() == 1) {
                Annotation annotation = (Annotation)values.iterator().next();
                ConnectionDefinitions connectionDefinitionsAnnotation = (ConnectionDefinitions)annotation.getAnnotation();
                log.tracef("Processing: %s", connectionDefinitionsAnnotation);
                return this.attachConnectionDefinitions(connectionDefinitionsAnnotation, annotation.getClassName(), classLoader, configProperties, plainConfigProperties);
            }
            throw new ValidateException(bundle.moreThanOneConnectionDefinitionsDefined());
        }
        return null;
    }

    private ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> attachConnectionDefinitions(ConnectionDefinitions cds, String mcf, ClassLoader classLoader, ArrayList<? extends ConfigProperty> configProperty, ArrayList<? extends ConfigProperty> plainConfigProperty) throws Exception {
        ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> connectionDefinitions = null;
        if (cds.value() != null) {
            connectionDefinitions = new ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition>(cds.value().length);
            for (ConnectionDefinition cd : cds.value()) {
                connectionDefinitions.add(this.attachConnectionDefinition(mcf, cd, classLoader, configProperty, plainConfigProperty));
            }
        }
        return connectionDefinitions;
    }

    private ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> processConnectionDefinition(AnnotationRepository annotationRepository, ClassLoader classLoader, ArrayList<? extends ConfigProperty> configProperty, ArrayList<? extends ConfigProperty> plainConfigProperty) throws Exception {
        ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition> connectionDefinitions = null;
        Collection values = annotationRepository.getAnnotation(ConnectionDefinition.class);
        if (values != null) {
            connectionDefinitions = new ArrayList<org.jboss.jca.common.api.metadata.spec.ConnectionDefinition>(values.size());
            for (Annotation annotation : values) {
                org.jboss.jca.common.api.metadata.spec.ConnectionDefinition cd = this.attachConnectionDefinition(annotation, classLoader, configProperty, plainConfigProperty);
                log.tracef("Adding connection definition: %s", cd);
                connectionDefinitions.add(cd);
            }
        }
        return connectionDefinitions;
    }

    private org.jboss.jca.common.api.metadata.spec.ConnectionDefinition attachConnectionDefinition(Annotation annotation, ClassLoader classLoader, ArrayList<? extends ConfigProperty> configProperty, ArrayList<? extends ConfigProperty> plainConfigProperty) throws Exception {
        ConnectionDefinition cd = (ConnectionDefinition)annotation.getAnnotation();
        log.tracef("Processing: %s", annotation);
        return this.attachConnectionDefinition(annotation.getClassName(), cd, classLoader, configProperty, plainConfigProperty);
    }

    private org.jboss.jca.common.api.metadata.spec.ConnectionDefinition attachConnectionDefinition(String mcf, ConnectionDefinition cd, ClassLoader classLoader, ArrayList<? extends ConfigProperty> configProperties, ArrayList<? extends ConfigProperty> plainConfigProperties) throws Exception {
        log.tracef("Processing: %s", cd);
        ArrayList<ConfigProperty> validProperties = new ArrayList<ConfigProperty>();
        if (configProperties != null) {
            for (ConfigProperty configProperty : configProperties) {
                if (!mcf.equals(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                log.tracef("Attaching: %s (%s)", configProperty, mcf);
                validProperties.add(configProperty);
            }
        }
        if (plainConfigProperties != null) {
            Set<String> mcfClasses = this.getClasses(mcf, classLoader);
            for (ConfigProperty configProperty : plainConfigProperties) {
                if (!mcfClasses.contains(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                log.tracef("Attaching: %s (%s)", configProperty, mcf);
                validProperties.add(configProperty);
            }
        }
        validProperties.trimToSize();
        XsdString connectionfactoryInterface = new XsdString(cd.connectionFactory().getName(), null);
        XsdString xsdString = new XsdString(mcf, null);
        XsdString xsdString2 = new XsdString(cd.connectionImpl().getName(), null);
        XsdString connectionfactoryImplClass = new XsdString(cd.connectionFactoryImpl().getName(), null);
        XsdString connectionInterface = new XsdString(cd.connection().getName(), null);
        return new ConnectionDefinitionImpl(xsdString, validProperties, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, xsdString2, null);
    }

    private Map<Metadatas, ArrayList<ConfigProperty>> processConfigProperty(AnnotationRepository annotationRepository, ClassLoader classLoader) throws Exception {
        HashMap<Metadatas, ArrayList<ConfigProperty>> valueMap = null;
        Collection values = annotationRepository.getAnnotation(javax.resource.spi.ConfigProperty.class);
        if (values != null) {
            valueMap = new HashMap<Metadatas, ArrayList<ConfigProperty>>();
            for (Annotation annotation : values) {
                ConfigPropertyImpl cfgMeta;
                javax.resource.spi.ConfigProperty configPropertyAnnotation = (javax.resource.spi.ConfigProperty)annotation.getAnnotation();
                log.tracef("Processing: %s", configPropertyAnnotation);
                XsdString configPropertyValue = XsdString.NULL_XSDSTRING;
                if (configPropertyAnnotation.defaultValue() != null && !configPropertyAnnotation.defaultValue().equals("")) {
                    configPropertyValue = new XsdString(configPropertyAnnotation.defaultValue(), null);
                }
                XsdString configPropertyName = new XsdString(this.getConfigPropertyName(annotation), null);
                XsdString configPropertyType = new XsdString(this.getConfigPropertyType(annotation, configPropertyAnnotation.type(), classLoader), null);
                Boolean configPropertySupportsDynamicUpdates = configPropertyAnnotation.supportsDynamicUpdates();
                Boolean configPropertyConfidential = configPropertyAnnotation.confidential();
                ArrayList<LocalizedXsdString> descriptions = null;
                if (configPropertyAnnotation.description() != null && configPropertyAnnotation.description().length != 0) {
                    descriptions = new ArrayList<LocalizedXsdString>(configPropertyAnnotation.description().length);
                    for (String descriptionAnnoptation : configPropertyAnnotation.description()) {
                        descriptions.add(new LocalizedXsdString(descriptionAnnoptation, null));
                    }
                }
                Boolean configPropertyIgnore = configPropertyAnnotation.ignore();
                String attachedClassName = annotation.getClassName();
                Class<?> attachedClass = Class.forName(attachedClassName, true, classLoader);
                if (this.hasInterface(attachedClass, "javax.resource.spi.ResourceAdapter")) {
                    cfgMeta = new ConfigPropertyImpl(descriptions, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, null, false, attachedClassName, null, null, null);
                    if (valueMap.get((Object)Metadatas.RA) == null) {
                        valueMap.put(Metadatas.RA, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.RA)).add(cfgMeta);
                    continue;
                }
                cfgMeta = new ConfigPropertyImpl(descriptions, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, null, false, attachedClassName, null, null, null);
                if (this.hasInterface(attachedClass, "javax.resource.spi.ManagedConnectionFactory")) {
                    if (valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY) == null) {
                        valueMap.put(Metadatas.MANAGED_CONN_FACTORY, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY)).add(cfgMeta);
                    continue;
                }
                if (this.hasInterface(attachedClass, "javax.resource.spi.ActivationSpec")) {
                    if (this.hasNotNull(annotationRepository, annotation)) {
                        cfgMeta.setMandatory(true);
                    }
                    if (valueMap.get((Object)Metadatas.ACTIVATION_SPEC) == null) {
                        valueMap.put(Metadatas.ACTIVATION_SPEC, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.ACTIVATION_SPEC)).add(cfgMeta);
                    continue;
                }
                if (this.hasAnnotation(attachedClass, AdministeredObject.class, annotationRepository)) {
                    if (valueMap.get((Object)Metadatas.ADMIN_OBJECT) == null) {
                        valueMap.put(Metadatas.ADMIN_OBJECT, new ArrayList());
                    }
                    ((ArrayList)valueMap.get((Object)Metadatas.ADMIN_OBJECT)).add(cfgMeta);
                    continue;
                }
                if (this.hasNotNull(annotationRepository, annotation)) {
                    cfgMeta.setMandatory(true);
                }
                if (valueMap.get((Object)Metadatas.PLAIN) == null) {
                    valueMap.put(Metadatas.PLAIN, new ArrayList());
                }
                ((ArrayList)valueMap.get((Object)Metadatas.PLAIN)).add(cfgMeta);
            }
            if (valueMap.get((Object)Metadatas.RA) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.RA)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.MANAGED_CONN_FACTORY)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.ACTIVATION_SPEC) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.ACTIVATION_SPEC)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.ADMIN_OBJECT) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.ADMIN_OBJECT)).trimToSize();
            }
            if (valueMap.get((Object)Metadatas.PLAIN) != null) {
                ((ArrayList)valueMap.get((Object)Metadatas.PLAIN)).trimToSize();
            }
            return valueMap;
        }
        return valueMap;
    }

    private boolean hasInterface(Class c, String targetClassName) {
        for (Class<?> face : c.getInterfaces()) {
            if (face.getName().equals(targetClassName)) {
                return true;
            }
            for (Class<?> face2 : face.getInterfaces()) {
                if (face2.getName().equals(targetClassName)) {
                    return true;
                }
                if (!this.hasInterface(face2, targetClassName)) continue;
                return true;
            }
        }
        if (null != c.getSuperclass()) {
            return this.hasInterface(c.getSuperclass(), targetClassName);
        }
        return false;
    }

    private boolean hasAnnotation(Class c, Class targetClass, AnnotationRepository annotationRepository) {
        Collection values = annotationRepository.getAnnotation(targetClass);
        if (values == null) {
            return false;
        }
        for (Annotation annotation : values) {
            if (annotation.getClassName() == null || !annotation.getClassName().equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    private ArrayList<AdminObject> processAdministeredObject(AnnotationRepository annotationRepository, ClassLoader classLoader, ArrayList<ConfigProperty> configProperties, ArrayList<ConfigProperty> plainConfigProperties) throws Exception {
        ArrayList<AdminObjectImpl> adminObjs = null;
        Collection values = annotationRepository.getAnnotation(AdministeredObject.class);
        if (values != null) {
            adminObjs = new ArrayList<AdminObjectImpl>(values.size());
            for (Annotation annotation : values) {
                AdministeredObject a = (AdministeredObject)annotation.getAnnotation();
                log.tracef("Processing: %s", a);
                String aoName = null;
                String aoClassName = annotation.getClassName();
                Class<?> aClass = Class.forName(aoClassName, true, classLoader);
                List<Object> declaredInterfaces = null;
                declaredInterfaces = aClass.getInterfaces() != null && aClass.getInterfaces().length != 0 ? Arrays.asList(aClass.getInterfaces()) : Collections.emptyList();
                if (a.adminObjectInterfaces() != null && a.adminObjectInterfaces().length > 0) {
                    for (Class annotatedInterface : a.adminObjectInterfaces()) {
                        if (!declaredInterfaces.contains(annotatedInterface) || annotatedInterface.equals(Serializable.class) || annotatedInterface.equals(Externalizable.class)) continue;
                        aoName = annotatedInterface.getName();
                        break;
                    }
                }
                ArrayList<ConfigProperty> validProperties = new ArrayList<ConfigProperty>();
                if (configProperties != null) {
                    for (ConfigProperty configProperty : configProperties) {
                        if (!aoClassName.equals(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                        log.tracef("Attaching: %s (%s)", configProperty, aoClassName);
                        validProperties.add(configProperty);
                    }
                }
                if (plainConfigProperties != null) {
                    Set<String> aoClasses = this.getClasses(aoClassName, classLoader);
                    for (ConfigProperty configProperty : plainConfigProperties) {
                        if (!aoClasses.contains(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                        log.tracef("Attaching: %s (%s)", configProperty, aoClassName);
                        validProperties.add(configProperty);
                    }
                }
                validProperties.trimToSize();
                XsdString adminobjectInterface = new XsdString(aoName, null);
                XsdString adminobjectClass = new XsdString(aoClassName, null);
                adminObjs.add(new AdminObjectImpl(adminobjectInterface, adminobjectClass, validProperties, null));
            }
        }
        return adminObjs;
    }

    private InboundResourceAdapter processActivation(AnnotationRepository annotationRepository, ClassLoader classLoader, ArrayList<ConfigProperty> configProperties, ArrayList<ConfigProperty> plainConfigProperties) throws Exception {
        ArrayList<MessageListener> listeners = new ArrayList<MessageListener>();
        Collection values = annotationRepository.getAnnotation(Activation.class);
        if (values != null) {
            for (Annotation annotation : values) {
                listeners.addAll(this.attachActivation(annotation, classLoader, configProperties, plainConfigProperties));
            }
            listeners.trimToSize();
        }
        return new InboundResourceAdapterImpl(new MessageAdapterImpl(listeners, null), null);
    }

    private ArrayList<MessageListener> attachActivation(Annotation annotation, ClassLoader classLoader, ArrayList<ConfigProperty> configProperties, ArrayList<ConfigProperty> plainConfigProperties) throws Exception {
        ArrayList<ConfigProperty> validProperties = new ArrayList<ConfigProperty>();
        ArrayList<RequiredConfigProperty> requiredConfigProperties = null;
        if (configProperties != null) {
            for (ConfigProperty configProperty : configProperties) {
                if (!annotation.getClassName().equals(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                validProperties.add(configProperty);
                if (!configProperty.isMandatory()) continue;
                if (requiredConfigProperties == null) {
                    requiredConfigProperties = new ArrayList<RequiredConfigProperty>(1);
                }
                requiredConfigProperties.add(new RequiredConfigPropertyImpl(null, configProperty.getConfigPropertyName(), null));
            }
        }
        if (plainConfigProperties != null) {
            Set<String> asClasses = this.getClasses(annotation.getClassName(), classLoader);
            for (ConfigProperty configProperty : plainConfigProperties) {
                if (!asClasses.contains(((ConfigPropertyImpl)configProperty).getAttachedClassName())) continue;
                validProperties.add(configProperty);
                if (!configProperty.isMandatory()) continue;
                if (requiredConfigProperties == null) {
                    requiredConfigProperties = new ArrayList(1);
                }
                requiredConfigProperties.add(new RequiredConfigPropertyImpl(null, configProperty.getConfigPropertyName(), null));
            }
        }
        validProperties.trimToSize();
        Activation activation = (Activation)annotation.getAnnotation();
        ArrayList<MessageListenerImpl> messageListeners = null;
        log.tracef("Processing: %", activation);
        if (activation.messageListeners() != null) {
            messageListeners = new ArrayList<MessageListenerImpl>(activation.messageListeners().length);
            for (Class asClass : activation.messageListeners()) {
                ActivationSpecImpl asMeta = new ActivationSpecImpl(new XsdString(annotation.getClassName(), null), requiredConfigProperties, validProperties, null);
                MessageListenerImpl mlMeta = new MessageListenerImpl(new XsdString(asClass.getName(), null), asMeta, null);
                messageListeners.add(mlMeta);
            }
        }
        return messageListeners;
    }

    private String getConfigPropertyName(Annotation annotation) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        if (annotation.isOnField()) {
            return annotation.getMemberName();
        }
        if (annotation.isOnMethod()) {
            String name = annotation.getMemberName();
            if (name.startsWith("set")) {
                name = name.substring(3);
            } else if (name.startsWith("get")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            if (name.length() > 1) {
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return Character.toString(Character.toLowerCase(name.charAt(0)));
        }
        throw new IllegalArgumentException(bundle.unknownAnnotation(annotation));
    }

    private String getConfigPropertyType(Annotation annotation, Class<?> type, ClassLoader classLoader) throws ClassNotFoundException, ValidateException {
        block13: {
            block12: {
                if (!annotation.isOnField()) break block12;
                Class<?> clz = Class.forName(annotation.getClassName(), true, classLoader);
                while (!Object.class.equals(clz)) {
                    try {
                        Field field = SecurityActions.getDeclaredField(clz, annotation.getMemberName());
                        if (type == null || type.equals(Object.class) || type.equals(field.getType())) {
                            return field.getType().getName();
                        }
                        throw new ValidateException(bundle.wrongAnnotationType(annotation));
                    }
                    catch (NoSuchFieldException nsfe) {
                        clz = clz.getSuperclass();
                    }
                }
                break block13;
            }
            if (!annotation.isOnMethod()) break block13;
            Class<?> clz = Class.forName(annotation.getClassName(), true, classLoader);
            Class[] parameters = null;
            if (annotation.getParameterTypes() != null) {
                parameters = new Class[annotation.getParameterTypes().size()];
                for (int i = 0; i < annotation.getParameterTypes().size(); ++i) {
                    String parameter = (String)annotation.getParameterTypes().get(i);
                    parameters[i] = Class.forName(parameter, true, classLoader);
                }
            }
            while (!Object.class.equals(clz)) {
                try {
                    Method method = SecurityActions.getDeclaredMethod(clz, annotation.getMemberName(), parameters);
                    if (Void.TYPE.equals(method.getReturnType())) {
                        if (parameters == null || parameters.length <= 0) continue;
                        if (type == null || type.equals(Object.class) || type.equals(parameters[0])) {
                            return parameters[0].getName();
                        }
                        throw new ValidateException(bundle.wrongAnnotationType(annotation));
                    }
                    if (type == null || type.equals(Object.class) || type.equals(method.getReturnType())) {
                        return method.getReturnType().getName();
                    }
                    throw new ValidateException(bundle.wrongAnnotationType(annotation));
                }
                catch (NoSuchMethodException nsme) {
                    clz = clz.getSuperclass();
                }
            }
        }
        throw new IllegalArgumentException(bundle.unknownAnnotation(annotation));
    }

    private Set<String> getClasses(String name, ClassLoader cl) {
        HashSet<String> result = new HashSet<String>();
        try {
            Class<?> clz = Class.forName(name, true, cl);
            while (!Object.class.equals(clz)) {
                result.add(clz.getName());
                clz = clz.getSuperclass();
            }
        }
        catch (Throwable t) {
            log.debugf("Couldn't load: %s", name);
        }
        return result;
    }

    private boolean hasNotNull(AnnotationRepository annotationRepository, Annotation annotation) {
        Collection values = annotationRepository.getAnnotation(NotNull.class);
        if (values == null || values.size() == 0) {
            return false;
        }
        for (Annotation notNullAnnotation : values) {
            if (!notNullAnnotation.getClassName().equals(annotation.getClassName()) || !notNullAnnotation.getMemberName().equals(annotation.getMemberName())) continue;
            return true;
        }
        return false;
    }

    private static enum Metadatas {
        RA,
        ACTIVATION_SPEC,
        MANAGED_CONN_FACTORY,
        ADMIN_OBJECT,
        PLAIN;

    }
}

