/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;

public class HotRodTypeConverter
implements TypeConverter<Object, Object, Object, Object> {
    private Marshaller marshaller;

    public HotRodTypeConverter() {
        this(null);
    }

    public HotRodTypeConverter(Marshaller marshaller) {
        this.marshaller = marshaller == null ? new GenericJBossMarshaller() : marshaller;
    }

    public Object boxKey(Object key) {
        return this.unmarshall(key);
    }

    public Object boxValue(Object value) {
        return this.unmarshall(value);
    }

    public Object unboxKey(Object target) {
        return this.marshall(target);
    }

    public Object unboxValue(Object target) {
        return this.marshall(target);
    }

    public boolean supportsInvocation(Flag flag) {
        return flag == Flag.OPERATION_HOTROD;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    private Object unmarshall(Object source) {
        if (source instanceof byte[]) {
            try {
                return this.marshaller.objectFromByteBuffer((byte[])source);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return source;
    }

    private Object marshall(Object source) {
        if (source != null) {
            try {
                if (this.marshaller.isMarshallable(source)) {
                    return this.marshaller.objectToByteBuffer(source);
                }
                return source;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return null;
    }
}

