/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import javax.security.auth.Subject;
import org.infinispan.security.Security;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ResponseWriting;

public class LocalContextHandler
extends ChannelInboundHandlerAdapter {
    private final NettyTransport transport;

    public LocalContextHandler(NettyTransport transport) {
        this.transport = transport;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CacheDecodeContext) {
            CacheDecodeContext cdc = (CacheDecodeContext)msg;
            Subject subject = ((CacheDecodeContext)msg).subject;
            if (subject == null) {
                this.realChannelRead(ctx, msg, cdc);
            } else {
                Security.doAs((Subject)subject, () -> {
                    this.realChannelRead(ctx, msg, cdc);
                    return null;
                });
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void realChannelRead(ChannelHandlerContext ctx, Object msg, CacheDecodeContext cdc) throws Exception {
        HotRodHeader h = cdc.header;
        switch (h.op) {
            case CONTAINS_KEY: {
                ResponseWriting.writeResponse(cdc, ctx.channel(), cdc.containsKey());
                break;
            }
            case GET: 
            case GET_WITH_VERSION: {
                ResponseWriting.writeResponse(cdc, ctx.channel(), cdc.get());
                break;
            }
            case GET_WITH_METADATA: {
                ResponseWriting.writeResponse(cdc, ctx.channel(), cdc.getKeyMetadata());
                break;
            }
            case PING: {
                ResponseWriting.writeResponse(cdc, ctx.channel(), new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.PING, OperationStatus.Success, h.topologyId));
                break;
            }
            case STATS: {
                ResponseWriting.writeResponse(cdc, ctx.channel(), cdc.decoder.createStatsResponse(cdc, this.transport));
                break;
            }
            default: {
                super.channelRead(ctx, msg);
            }
        }
    }
}

