/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryBuilderImpl;
import org.hibernate.search.elasticsearch.analyzer.definition.spi.ElasticsearchAnalysisDefinitionProvider;
import org.hibernate.search.elasticsearch.analyzer.impl.ChainingElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.CustomElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.LuceneClassElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.SimpleElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.TranslatingElasticsearchAnalyzerDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.analyzer.impl.UndefinedElasticsearchAnalyzerImpl;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchAnalyzerStrategy
implements AnalyzerStrategy {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ServiceManager serviceManager;
    private final SearchConfiguration cfg;

    public ElasticsearchAnalyzerStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        this.serviceManager = serviceManager;
        this.cfg = cfg;
    }

    private SimpleElasticsearchAnalysisDefinitionRegistry createDefaultDefinitionRegistry() {
        ElasticsearchAnalysisDefinitionRegistryBuilderImpl builder = new ElasticsearchAnalysisDefinitionRegistryBuilderImpl();
        String providerClassName = this.cfg.getProperty("hibernate.search.elasticsearch.analyzer_definition_provider");
        if (providerClassName != null) {
            ElasticsearchAnalysisDefinitionProvider provider;
            try {
                Class providerClazz = ClassLoaderHelper.classForName((String)providerClassName, (ServiceManager)this.serviceManager);
                provider = (ElasticsearchAnalysisDefinitionProvider)ReflectionHelper.createInstance((Class)providerClazz, (boolean)true);
            }
            catch (RuntimeException e) {
                throw LOG.invalidElasticsearchAnalyzerDefinitionProvider(providerClassName, e);
            }
            try {
                provider.register(builder);
            }
            catch (SearchException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw LOG.invalidLuceneAnalyzerDefinitionProvider(providerClassName, e);
            }
        }
        return builder.build();
    }

    public ElasticsearchAnalyzerReference createDefaultAnalyzerReference() {
        return new NamedElasticsearchAnalyzerReference("default");
    }

    public ElasticsearchAnalyzerReference createPassThroughAnalyzerReference() {
        return new NamedElasticsearchAnalyzerReference("keyword");
    }

    public NamedElasticsearchAnalyzerReference createNamedAnalyzerReference(String name) {
        return new NamedElasticsearchAnalyzerReference(name);
    }

    public ElasticsearchAnalyzerReference createLuceneClassAnalyzerReference(Class<?> analyzerClass) {
        return new LuceneClassElasticsearchAnalyzerReference(analyzerClass);
    }

    public Map<String, AnalyzerReference> initializeAnalyzerReferences(Collection<AnalyzerReference> references, Map<String, AnalyzerDef> analyzerDefinitions) {
        try (ServiceReference translatorReference = this.serviceManager.requestReference(ElasticsearchAnalyzerDefinitionTranslator.class);){
            ElasticsearchAnalyzerDefinitionTranslator translator = (ElasticsearchAnalyzerDefinitionTranslator)translatorReference.get();
            SimpleElasticsearchAnalysisDefinitionRegistry defaultDefinitionRegistry = this.createDefaultDefinitionRegistry();
            ElasticsearchAnalysisDefinitionRegistry definitionRegistry = this.createDefinitionRegistry(references, defaultDefinitionRegistry, analyzerDefinitions, translator);
            HashSet<String> existingNamedReferences = new HashSet<String>();
            for (AnalyzerReference reference : references) {
                ScopedElasticsearchAnalyzerReference scopedReference;
                if (reference.is(NamedElasticsearchAnalyzerReference.class)) {
                    NamedElasticsearchAnalyzerReference namedReference = (NamedElasticsearchAnalyzerReference)reference.unwrap(NamedElasticsearchAnalyzerReference.class);
                    if (!namedReference.isInitialized()) {
                        this.initializeNamedReference(namedReference, definitionRegistry);
                    }
                    existingNamedReferences.add(namedReference.getAnalyzerName());
                    continue;
                }
                if (reference.is(LuceneClassElasticsearchAnalyzerReference.class)) {
                    LuceneClassElasticsearchAnalyzerReference luceneClassReference = (LuceneClassElasticsearchAnalyzerReference)reference.unwrap(LuceneClassElasticsearchAnalyzerReference.class);
                    if (luceneClassReference.isInitialized()) continue;
                    this.initializeLuceneClassReference(luceneClassReference, translator);
                    continue;
                }
                if (!reference.is(ScopedElasticsearchAnalyzerReference.class) || (scopedReference = (ScopedElasticsearchAnalyzerReference)reference.unwrap(ScopedElasticsearchAnalyzerReference.class)).isInitialized()) continue;
                scopedReference.initialize();
            }
            HashMap<String, NamedElasticsearchAnalyzerReference> additionalNamedReferences = new HashMap<String, NamedElasticsearchAnalyzerReference>();
            for (String defaultAnalyzerName : defaultDefinitionRegistry.getAnalyzerDefinitions().keySet()) {
                if (existingNamedReferences.contains(defaultAnalyzerName)) continue;
                NamedElasticsearchAnalyzerReference reference = this.createNamedAnalyzerReference(defaultAnalyzerName);
                this.initializeNamedReference(reference, definitionRegistry);
                additionalNamedReferences.put(defaultAnalyzerName, reference);
            }
            HashMap<String, NamedElasticsearchAnalyzerReference> hashMap = additionalNamedReferences;
            return hashMap;
        }
    }

    private ElasticsearchAnalysisDefinitionRegistry createDefinitionRegistry(Collection<AnalyzerReference> references, ElasticsearchAnalysisDefinitionRegistry defaultDefinitionRegistry, Map<String, AnalyzerDef> analyzerDefinitions, ElasticsearchAnalyzerDefinitionTranslator translator) {
        ChainingElasticsearchAnalysisDefinitionRegistry definitionRegistry = new ChainingElasticsearchAnalysisDefinitionRegistry(defaultDefinitionRegistry);
        for (AnalyzerReference reference : references) {
            NamedElasticsearchAnalyzerReference namedReference;
            if (!reference.is(NamedElasticsearchAnalyzerReference.class) || !(namedReference = (NamedElasticsearchAnalyzerReference)reference.unwrap(NamedElasticsearchAnalyzerReference.class)).isInitialized()) continue;
            namedReference.getAnalyzer().registerDefinitions(definitionRegistry, null);
        }
        TranslatingElasticsearchAnalyzerDefinitionRegistryPopulator translatingPopulator = new TranslatingElasticsearchAnalyzerDefinitionRegistryPopulator(definitionRegistry, translator);
        for (AnalyzerReference reference : references) {
            String name;
            AnalyzerDef hibernateSearchAnalyzerDef;
            NamedElasticsearchAnalyzerReference namedReference;
            if (!reference.is(NamedElasticsearchAnalyzerReference.class) || (namedReference = (NamedElasticsearchAnalyzerReference)reference.unwrap(NamedElasticsearchAnalyzerReference.class)).isInitialized() || (hibernateSearchAnalyzerDef = analyzerDefinitions.get(name = namedReference.getAnalyzerName())) == null) continue;
            translatingPopulator.registerAnalyzerDef(hibernateSearchAnalyzerDef);
        }
        return definitionRegistry;
    }

    private void initializeNamedReference(NamedElasticsearchAnalyzerReference analyzerReference, ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        String name = analyzerReference.getAnalyzerName();
        ElasticsearchAnalyzer analyzer = this.createAnalyzer(definitionRegistry, name);
        analyzerReference.initialize(analyzer);
    }

    private void initializeLuceneClassReference(LuceneClassElasticsearchAnalyzerReference analyzerReference, ElasticsearchAnalyzerDefinitionTranslator translator) {
        Class<?> clazz = analyzerReference.getLuceneClass();
        String name = translator.translate(clazz);
        UndefinedElasticsearchAnalyzerImpl analyzer = new UndefinedElasticsearchAnalyzerImpl(name);
        analyzerReference.initialize(name, analyzer);
    }

    public ScopedAnalyzerReference.Builder buildScopedAnalyzerReference(AnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedElasticsearchAnalyzerReference.DeferredInitializationBuilder((ElasticsearchAnalyzerReference)initialGlobalAnalyzerReference.unwrap(ElasticsearchAnalyzerReference.class), Collections.emptyMap());
    }

    private ElasticsearchAnalyzer createAnalyzer(ElasticsearchAnalysisDefinitionRegistry definitionRegistry, String analyzerName) {
        AnalyzerDefinition analyzerDefinition = definitionRegistry.getAnalyzerDefinition(analyzerName);
        if (analyzerDefinition == null) {
            return new UndefinedElasticsearchAnalyzerImpl(analyzerName);
        }
        String tokenizerName = analyzerDefinition.getTokenizer();
        TokenizerDefinition tokenizerDefinition = definitionRegistry.getTokenizerDefinition(tokenizerName);
        TreeMap<String, TokenFilterDefinition> tokenFilters = new TreeMap<String, TokenFilterDefinition>();
        if (analyzerDefinition.getTokenFilters() != null) {
            for (String name : analyzerDefinition.getTokenFilters()) {
                TokenFilterDefinition definition = definitionRegistry.getTokenFilterDefinition(name);
                if (definition == null) continue;
                tokenFilters.put(name, definition);
            }
        }
        TreeMap<String, CharFilterDefinition> charFilters = new TreeMap<String, CharFilterDefinition>();
        if (analyzerDefinition.getCharFilters() != null) {
            for (String name : analyzerDefinition.getCharFilters()) {
                CharFilterDefinition definition = definitionRegistry.getCharFilterDefinition(name);
                if (definition == null) continue;
                charFilters.put(name, definition);
            }
        }
        return new CustomElasticsearchAnalyzerImpl(analyzerName, analyzerDefinition, tokenizerName, tokenizerDefinition, charFilters, tokenFilters);
    }
}

