/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchInstantBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchMonthDayBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearMonthBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchZonedDateTimeBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchJavaTimeBridgeProvider
implements BridgeProvider {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final boolean ACTIVATED = ElasticsearchJavaTimeBridgeProvider.javaTimePackageExists();
    private final Map<String, FieldBridge> builtInBridges = ElasticsearchJavaTimeBridgeProvider.isActive() ? ElasticsearchJavaTimeBridgeProvider.populateBridgeMap() : Collections.emptyMap();

    ElasticsearchJavaTimeBridgeProvider() {
    }

    private static Map<String, FieldBridge> populateBridgeMap() {
        HashMap<String, FieldBridge> bridges = new HashMap<String, FieldBridge>(7);
        bridges.put(Year.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchYearBridge.INSTANCE));
        bridges.put(YearMonth.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchYearMonthBridge.INSTANCE));
        bridges.put(MonthDay.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchMonthDayBridge.INSTANCE));
        bridges.put(LocalDateTime.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalDateTimeBridge.INSTANCE));
        bridges.put(LocalDate.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalDateBridge.INSTANCE));
        bridges.put(LocalTime.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalTimeBridge.INSTANCE));
        bridges.put(Instant.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchInstantBridge.INSTANCE));
        bridges.put(OffsetDateTime.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchOffsetDateTimeBridge.INSTANCE));
        bridges.put(OffsetTime.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchOffsetTimeBridge.INSTANCE));
        bridges.put(ZonedDateTime.class.getName(), (FieldBridge)new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchZonedDateTimeBridge.INSTANCE));
        return bridges;
    }

    public static boolean isActive() {
        return ACTIVATED;
    }

    private static boolean javaTimePackageExists() {
        try {
            Class.forName("java.time.LocalDate");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.javaTimeBridgeWontBeAdded(e);
            return false;
        }
    }

    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext bridgeProviderContext) {
        return this.builtInBridges.get(bridgeProviderContext.getReturnType().getName());
    }
}

