/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonElement;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.BulkResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.JestAPIFormatter;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultBackendRequestResultAssessor
implements BackendRequestResultAssessor<JestResult> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int TIME_OUT_HTTP_RESPONSE_CODE = 408;
    private final JestAPIFormatter formatter;
    private final Set<Integer> ignoredErrorStatuses;
    private final Set<String> ignoredErrorTypes;

    public static Builder builder(JestAPIFormatter formatter) {
        return new Builder(formatter);
    }

    private DefaultBackendRequestResultAssessor(Builder builder) {
        this.formatter = builder.formatter;
        this.ignoredErrorStatuses = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorStatuses));
        this.ignoredErrorTypes = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorTypes));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "ignoredErrorStatuses=" + this.ignoredErrorStatuses + ", ignoredErrorTypes=" + this.ignoredErrorTypes + "]";
    }

    @Override
    public void checkSuccess(Action<? extends JestResult> request, JestResult result) throws SearchException {
        if (!this.isSuccess(result)) {
            if (result.getResponseCode() == 408) {
                throw LOG.elasticsearchRequestTimeout(this.formatter.formatRequest(request), this.formatter.formatResult(result));
            }
            throw LOG.elasticsearchRequestFailed(this.formatter.formatRequest(request), this.formatter.formatResult(result), null);
        }
    }

    @Override
    public boolean isSuccess(BulkResult.BulkResultItem resultItem) {
        return resultItem.error == null && resultItem.status < 400 || this.ignoredErrorStatuses.contains(resultItem.status) || this.ignoredErrorTypes.contains(resultItem.errorType);
    }

    private boolean isSuccess(JestResult result) {
        return result.isSucceeded() || this.ignoredErrorStatuses.contains(result.getResponseCode()) || this.ignoredErrorTypes.contains(this.getErrorType(result));
    }

    private String getErrorType(JestResult result) {
        JsonElement error = result.getJsonObject().get("error");
        if (error == null || !error.isJsonObject()) {
            return null;
        }
        JsonElement errorType = error.getAsJsonObject().get("type");
        if (errorType == null || !errorType.isJsonPrimitive()) {
            return null;
        }
        return errorType.getAsString();
    }

    public static class Builder {
        private final JestAPIFormatter formatter;
        private final Set<Integer> ignoredErrorStatuses = new HashSet<Integer>();
        private final Set<String> ignoredErrorTypes = new HashSet<String>();

        private Builder(JestAPIFormatter formatter) {
            this.formatter = formatter;
        }

        public Builder ignoreErrorStatuses(int ... ignoredErrorStatuses) {
            for (int ignoredErrorStatus : ignoredErrorStatuses) {
                this.ignoredErrorStatuses.add(ignoredErrorStatus);
            }
            return this;
        }

        public Builder ignoreErrorTypes(String ... ignoredErrorTypes) {
            for (String ignoredErrorType : ignoredErrorTypes) {
                this.ignoredErrorTypes.add(ignoredErrorType);
            }
            return this;
        }

        public DefaultBackendRequestResultAssessor build() {
            return new DefaultBackendRequestResultAssessor(this);
        }
    }
}

