/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Properties;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;

public class DefaultElasticsearchSchemaDropper
implements ElasticsearchSchemaDropper,
Startable,
Stoppable {
    private ServiceManager serviceManager;
    private ElasticsearchSchemaAccessor schemaAccessor;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.schemaAccessor = (ElasticsearchSchemaAccessor)this.serviceManager.requestService(ElasticsearchSchemaAccessor.class);
    }

    public void stop() {
        this.schemaAccessor = null;
        this.serviceManager.releaseService(ElasticsearchSchemaAccessor.class);
        this.serviceManager = null;
    }

    @Override
    public void drop(String indexName, ExecutionOptions executionOptions) {
        this.schemaAccessor.dropIndex(indexName, executionOptions);
    }

    @Override
    public void dropIfExisting(String indexName, ExecutionOptions executionOptions) {
        block3: {
            if (!this.schemaAccessor.indexExists(indexName)) {
                return;
            }
            try {
                this.schemaAccessor.dropIndex(indexName, executionOptions);
            }
            catch (SearchException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block3;
                throw e;
            }
        }
    }
}

