/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.AdvancedCache;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.FilterParsingResult;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.ResultProcessor;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ProtobufFieldBridgeProvider;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

final class RemoteQueryEngine
extends QueryEngine<Descriptor> {
    private final boolean isCompatMode;
    private final ProtobufFieldBridgeProvider protobufFieldBridgeProvider = new ProtobufFieldBridgeProvider();
    private final SerializationContext serializationContext;
    private final EmbeddedQueryFactory queryFactory = new EmbeddedQueryFactory((QueryEngine)this);

    public RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed, boolean isCompatMode) {
        super(cache, isIndexed, isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
        this.isCompatMode = isCompatMode;
        this.serializationContext = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
    }

    protected SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    protected BaseQuery makeQuery(String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        BaseQuery query = this.queryFactory.create(queryString);
        query.startOffset(startOffset);
        query.maxResults(maxResults);
        if (namedParameters != null) {
            query.setParameters(namedParameters);
        }
        return query;
    }

    protected ResultProcessor makeResultProcessor(ResultProcessor in) {
        return result -> {
            if (result instanceof ProtobufValueWrapper) {
                result = ((ProtobufValueWrapper)result).getBinary();
            }
            return in != null ? in.process(result) : result;
        };
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes) {
        if (this.isCompatMode) {
            return null;
        }
        int[] pos = new int[projectedTypes.length];
        int len = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            pos[len++] = i;
        }
        if (len == 0) {
            return null;
        }
        int[] cols = len < pos.length ? Arrays.copyOf(pos, len) : pos;
        return row -> {
            for (int i : cols) {
                if (row[i] == null) continue;
                row[i] = "true".equals(row[i]);
            }
            return row;
        };
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return this.isCompatMode ? query : new BooleanQuery.Builder().add((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.FILTER).add(query, BooleanClause.Occur.MUST).build();
    }

    protected JPAFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return this.isIndexed && !this.isCompatMode ? new JPAProtobufFilterAndConverter(queryString, namedParameters) : super.createFilter(queryString, namedParameters);
    }

    protected Class<?> getTargetedClass(FilterParsingResult<?> parsingResult) {
        return this.isCompatMode ? (Class)parsingResult.getTargetEntityMetadata() : ProtobufValueWrapper.class;
    }

    protected LuceneQueryMaker<Descriptor> createLuceneQueryMaker() {
        return this.isCompatMode ? super.createLuceneQueryMaker() : new LuceneQueryMaker(this.getSearchFactory(), (LuceneQueryMaker.FieldBridgeProvider)this.protobufFieldBridgeProvider);
    }
}

