/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValue;

public class HashableMarshalledValue<T>
extends SimpleMarshalledValue<T> {
    private static final long serialVersionUID = -7576022002375288323L;
    private transient int hashCode;

    public HashableMarshalledValue(T object, MarshallingContext context) {
        super(object, context);
        this.hashCode = object != null ? object.hashCode() : 0;
    }

    HashableMarshalledValue(byte[] bytes, int hashCode) {
        super(bytes);
        this.hashCode = hashCode;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof HashableMarshalledValue) {
            HashableMarshalledValue value = (HashableMarshalledValue)object;
            if (this.hashCode != value.hashCode) {
                return false;
            }
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.hashCode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hashCode = in.readInt();
    }
}

