/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.protocols.pbcast.StreamingStateTransfer;
import org.jgroups.util.BlockingInputStream;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Streaming state transfer protocol")
public class STATE
extends StreamingStateTransfer {
    protected volatile BlockingInputStream input_stream;

    @Override
    protected void handleViewChange(View v) {
        super.handleViewChange(v);
        if (this.state_provider != null && !v.getMembers().contains(this.state_provider)) {
            Util.close((Closeable)this.input_stream);
            this.openBarrierAndResumeStable();
            EOFException ex = new EOFException("state provider " + this.state_provider + " left");
            this.up_prot.up(new Event(73, new StateTransferResult(ex)));
        }
    }

    @Override
    protected void handleEOF(Address sender) {
        Util.close((Closeable)this.input_stream);
        super.handleEOF(sender);
    }

    @Override
    protected void handleException(Throwable exception) {
        Util.close((Closeable)this.input_stream);
        super.handleException(exception);
    }

    @Override
    protected void handleStateChunk(Address sender, byte[] buffer, int offset, int length) {
        if (buffer == null || this.input_stream == null) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: received chunk of %s from %s", this.local_addr, Util.printBytes(length), sender);
            }
            this.input_stream.write(buffer, offset, length);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    @Override
    protected void createStreamToRequester(Address requester) {
        StateOutputStream bos = new StateOutputStream(requester);
        this.getStateFromApplication(requester, bos, false);
    }

    @Override
    protected Tuple<InputStream, Object> createStreamToProvider(Address provider, StreamingStateTransfer.StateHeader hdr) {
        Util.close((Closeable)this.input_stream);
        this.input_stream = new BlockingInputStream(this.buffer_size);
        return new Tuple<BlockingInputStream, Object>(this.input_stream, null);
    }

    @Override
    protected boolean useAsyncStateDelivery() {
        return true;
    }

    protected class StateOutputStream
    extends OutputStream {
        protected final Address stateRequester;
        protected final AtomicBoolean closed;
        protected long bytesWrittenCounter;

        public StateOutputStream(Address stateRequester) {
            this.stateRequester = stateRequester;
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true) && STATE.this.stats) {
                STATE.this.num_bytes_sent.add(this.bytesWrittenCounter);
                STATE.this.avg_state_size = (double)STATE.this.num_bytes_sent.sum() / STATE.this.num_state_reqs.doubleValue();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed.get()) {
                throw new IOException("The output stream is closed");
            }
            this.sendMessage(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.closed.get()) {
                throw new IOException("The output stream is closed");
            }
            this.sendMessage(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed.get()) {
                throw new IOException("The output stream is closed");
            }
            byte[] buf = new byte[]{(byte)b};
            this.write(buf);
        }

        protected void sendMessage(byte[] b, int off, int len) throws IOException {
            Message m = new Message(this.stateRequester).putHeader(STATE.this.id, new StreamingStateTransfer.StateHeader(3));
            byte[] data = new byte[len];
            System.arraycopy(b, off, data, 0, len);
            m.setBuffer(data);
            this.bytesWrittenCounter += (long)len;
            if (Thread.interrupted()) {
                throw this.interrupted((int)this.bytesWrittenCounter);
            }
            STATE.this.down_prot.down(m);
            if (STATE.this.log.isTraceEnabled()) {
                STATE.this.log.trace("%s: sent chunk of %s to %s", STATE.this.local_addr, Util.printBytes(len), this.stateRequester);
            }
        }

        protected InterruptedIOException interrupted(int cnt) {
            InterruptedIOException ex = new InterruptedIOException();
            ex.bytesTransferred = cnt;
            return ex;
        }
    }
}

