/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.MimeMetadata;
import org.infinispan.rest.MimeMetadataBuilder;

class MimeLifespanExpirableMetadata
extends MimeMetadata {
    private final long lifespanTime;
    private final TimeUnit lifespanUnit;

    MimeLifespanExpirableMetadata(String contentType, long lifespanTime, TimeUnit lifespanUnit) {
        super(contentType);
        this.lifespanTime = lifespanTime;
        this.lifespanUnit = Objects.requireNonNull(lifespanUnit);
    }

    @Override
    public long lifespan() {
        return this.lifespanUnit.toMillis(this.lifespanTime);
    }

    @Override
    public Metadata.Builder builder() {
        return new MimeMetadataBuilder().contentType(this.contentType).lifespan(this.lifespanTime, this.lifespanUnit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MimeLifespanExpirableMetadata that = (MimeLifespanExpirableMetadata)o;
        if (this.lifespanTime != that.lifespanTime) {
            return false;
        }
        return this.lifespanUnit == that.lifespanUnit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.lifespanTime ^ this.lifespanTime >>> 32);
        result = 31 * result + this.lifespanUnit.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MimeLifespanExpirableMetadata{lifespanTime=" + this.lifespanTime + ", lifespanUnit=" + (Object)((Object)this.lifespanUnit) + '}';
    }
}

