/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.utils;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;

public class SslUtils {
    public static JdkSslContext createNettySslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration) {
        return SslUtils.createSslContext(SslUtils.createJdkSslContext(sslConfiguration, sslEngineConfiguration), SslUtils.requireClientAuth(sslConfiguration));
    }

    public static SSLContext createJdkSslContext(SslConfiguration sslConfiguration, SslEngineConfiguration sslEngineConfiguration) {
        if (sslEngineConfiguration.sslContext() != null) {
            return sslEngineConfiguration.sslContext();
        }
        return SslContextFactory.getContext((String)sslEngineConfiguration.keyStoreFileName(), (char[])sslEngineConfiguration.keyStorePassword(), (char[])sslEngineConfiguration.keyStoreCertificatePassword(), (String)sslEngineConfiguration.trustStoreFileName(), (char[])sslEngineConfiguration.trustStorePassword());
    }

    public static JdkSslContext createSslContext(SSLContext sslContext, ClientAuth clientAuth) {
        String[] ciphers = SslContextFactory.getEngine((SSLContext)sslContext, (boolean)false, (boolean)false).getSupportedCipherSuites();
        return new JdkSslContext(sslContext, false, Arrays.asList(ciphers), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, clientAuth);
    }

    public static ClientAuth requireClientAuth(SslConfiguration sslConfig) {
        return sslConfig.requireClientAuth() ? ClientAuth.REQUIRE : ClientAuth.NONE;
    }
}

