/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.service.InjectedValueDependency;
import org.infinispan.server.commons.service.ValueDependency;
import org.infinispan.server.jgroups.spi.TransportConfiguration;
import org.infinispan.server.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.network.SocketBinding;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;

public class TransportConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<TransportConfiguration>
implements TransportConfiguration {
    private ValueDependency<SocketBinding> diagnosticsSocketBinding;
    private boolean shared = TransportResourceDefinition.SHARED.getDefaultValue().asBoolean();
    private TransportConfiguration.Topology topology = null;

    public TransportConfigurationBuilder(String stackName, String name) {
        super(stackName, name);
    }

    @Override
    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.diagnosticsSocketBinding != null) {
            this.diagnosticsSocketBinding.register(builder);
        }
        return builder;
    }

    public TransportConfiguration getValue() {
        return this;
    }

    public TransportConfigurationBuilder setModule(ModuleIdentifier module) {
        super.setModule(module);
        return this;
    }

    public TransportConfigurationBuilder setSocketBinding(String socketBindingName) {
        super.setSocketBinding(socketBindingName);
        return this;
    }

    public TransportConfigurationBuilder addProperty(String name, String value) {
        super.addProperty(name, value);
        return this;
    }

    public TransportConfigurationBuilder setDiagnosticsSocket(String socketBindingName) {
        if (socketBindingName != null) {
            this.diagnosticsSocketBinding = new InjectedValueDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class);
        }
        return this;
    }

    public TransportConfigurationBuilder setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public TransportConfigurationBuilder setTopology(final String site, final String rack, final String machine) {
        if (site != null || rack != null || machine != null) {
            this.topology = new TransportConfiguration.Topology(){

                @Override
                public String getMachine() {
                    return machine;
                }

                @Override
                public String getRack() {
                    return rack;
                }

                @Override
                public String getSite() {
                    return site;
                }
            };
        }
        return this;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public SocketBinding getDiagnosticsSocketBinding() {
        return this.diagnosticsSocketBinding != null ? (SocketBinding)this.diagnosticsSocketBinding.getValue() : null;
    }

    @Override
    public TransportConfiguration.Topology getTopology() {
        return this.topology;
    }
}

