/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.rest;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.rest.Server;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.RestRouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.Router;
import org.infinispan.server.router.routes.PrefixedRouteSource;
import org.infinispan.server.router.routes.rest.NettyRestServerRouteDestination;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class RestRouter
implements Router {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private static final String REST_PREFIX = "rest/";
    private final RestRouterConfiguration configuration;
    private Optional<Integer> port = Optional.empty();
    private Optional<InetAddress> ip = Optional.empty();
    private Optional<NettyJaxrsServer> nettyServer = Optional.empty();

    public RestRouter(RestRouterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void start(RoutingTable routingTable) {
        try {
            NettyJaxrsServer netty = new NettyJaxrsServer();
            ResteasyDeployment deployment = new ResteasyDeployment();
            netty.setDeployment(deployment);
            this.nettyServer = Optional.of(netty);
            netty.setHostname(this.configuration.getIp().getHostName());
            netty.setPort(this.configuration.getPort());
            netty.setRootResourcePath("");
            netty.setSecurityDomain(null);
            netty.start();
            this.addDeployments(netty, routingTable);
            this.ip = Optional.of(this.configuration.getIp());
            this.port = Optional.of(this.configuration.getPort());
            logger.restRouterStarted(this.ip, this.port);
        }
        catch (Exception e) {
            throw logger.restRouterStartFailed(e);
        }
    }

    private void addDeployments(NettyJaxrsServer netty, RoutingTable routingTable) {
        routingTable.streamRoutes(PrefixedRouteSource.class, NettyRestServerRouteDestination.class).forEach(r -> {
            String routePrefix = ((PrefixedRouteSource)r.getRouteSource()).getRoutePrefix();
            Server targetResource = ((NettyRestServerRouteDestination)r.getRouteDesitnation()).getRestResource();
            netty.getDeployment().getRegistry().addSingletonResource((Object)targetResource, REST_PREFIX + routePrefix);
            netty.getDeployment().getProviderFactory().register((Object)new RestAccessLoggingHandler(), new Class[]{ContainerResponseFilter.class, ContainerRequestFilter.class});
        });
    }

    @Override
    public void stop() {
        this.nettyServer.ifPresent(NettyJaxrsServer::stop);
        this.nettyServer = Optional.empty();
        this.ip = Optional.empty();
        this.port = Optional.empty();
    }

    @Override
    public Optional<InetAddress> getIp() {
        return this.ip;
    }

    @Override
    public Optional<Integer> getPort() {
        return this.port;
    }

    @Override
    public Router.Protocol getProtocol() {
        return Router.Protocol.REST;
    }
}

