/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.cloner;

import org.jboss.marshalling.cloner.CloneableCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectClonerSource;
import org.jboss.marshalling.cloner.SerializingCloner;

public final class ObjectCloners {
    private static final ObjectClonerFactory CLONEABLE = new ObjectClonerFactory(){

        @Override
        public ObjectCloner createCloner(ClonerConfiguration configuration) {
            return new CloneableCloner(configuration);
        }
    };
    private static final ObjectClonerFactory SERIALIZING = new ObjectClonerFactory(){

        @Override
        public ObjectCloner createCloner(ClonerConfiguration configuration) {
            return new SerializingCloner(configuration);
        }
    };

    private ObjectCloners() {
    }

    public static ObjectClonerFactory getCloneableObjectClonerFactory() {
        return CLONEABLE;
    }

    public static ObjectClonerFactory getSerializingObjectClonerFactory() {
        return SERIALIZING;
    }

    public static ObjectClonerSource createObjectClonerSource(final ObjectClonerFactory factory, ClonerConfiguration configuration) {
        final ClonerConfiguration finalConfig = configuration.clone();
        return new ObjectClonerSource(){

            @Override
            public ObjectCloner createNew() {
                return factory.createCloner(finalConfig);
            }
        };
    }
}

