/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.infinispan.server.commons.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;

public class InfinispanResourceDescriptionResolver
extends SubsystemResourceDescriptionResolver {
    private Map<String, String> sharedAttributeResolver = new HashMap<String, String>();

    InfinispanResourceDescriptionResolver() {
        this(Collections.emptyList());
    }

    InfinispanResourceDescriptionResolver(String keyPrefix) {
        this(Collections.singletonList(keyPrefix));
    }

    InfinispanResourceDescriptionResolver(String ... keyPrefixes) {
        this(Arrays.asList(keyPrefixes));
    }

    private InfinispanResourceDescriptionResolver(List<String> keyPrefixes) {
        super("datagrid-infinispan", keyPrefixes, InfinispanExtension.class);
        this.initMap();
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle2);
    }

    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getVariableBundleKey(attributeName, "deprecated"));
        }
        return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle2);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
    }

    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getVariableBundleKey(paramName, "deprecated"));
        }
        return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle2);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(childType)) {
            return bundle2.getString(this.getBundleKey(childType));
        }
        return super.getChildTypeDescription(childType, locale, bundle2);
    }

    private String getBundleKey(String name) {
        return this.getVariableBundleKey(name, new String[0]);
    }

    private String getVariableBundleKey(String name, String ... variable) {
        String prefix = this.sharedAttributeResolver.get(name);
        StringBuilder sb = new StringBuilder("datagrid-infinispan");
        if (prefix != null) {
            sb.append('.').append(prefix);
        }
        sb.append('.').append(name);
        if (variable != null) {
            for (String arg : variable) {
                sb.append('.').append(arg);
            }
        }
        return sb.toString();
    }

    private void initMap() {
        this.sharedAttributeResolver = new HashMap<String, String>();
        this.sharedAttributeResolver.put("batching", "cache");
        this.sharedAttributeResolver.put("configuration", "cache");
        this.sharedAttributeResolver.put("module", "cache");
        this.sharedAttributeResolver.put("jndi-name", "cache");
        this.sharedAttributeResolver.put("name", "cache");
        this.sharedAttributeResolver.put("remote-cache", "cache");
        this.sharedAttributeResolver.put("remote-site", "cache");
        this.sharedAttributeResolver.put("simple-cache", "cache");
        this.sharedAttributeResolver.put("start", "cache");
        this.sharedAttributeResolver.put("statistics", "cache");
        this.sharedAttributeResolver.put("statistics-available", "cache");
        this.sharedAttributeResolver.put("template", "cache");
        this.sharedAttributeResolver.put("cache-availability", "clustered-cache");
        this.sharedAttributeResolver.put("cache-rebalance", "clustered-cache");
        this.sharedAttributeResolver.put("cache-rebalancing-status", "clustered-cache");
        this.sharedAttributeResolver.put("mode", "clustered-cache");
        this.sharedAttributeResolver.put("remote-timeout", "clustered-cache");
        this.sharedAttributeResolver.put("properties", "loader");
        this.sharedAttributeResolver.put("fetch-state", "store");
        this.sharedAttributeResolver.put("passivation", "store");
        this.sharedAttributeResolver.put("preload", "store");
        this.sharedAttributeResolver.put("purge", "store");
        this.sharedAttributeResolver.put("read-only", "store");
        this.sharedAttributeResolver.put("shared", "store");
        this.sharedAttributeResolver.put("singleton", "store");
        this.sharedAttributeResolver.put("property", "store");
        this.sharedAttributeResolver.put("properties", "store");
        this.sharedAttributeResolver.put("datasource", "jdbc-store");
        this.sharedAttributeResolver.put("db-major-version", "jdbc-store");
        this.sharedAttributeResolver.put("db-minor-version", "jdbc-store");
        this.sharedAttributeResolver.put("dialect", "jdbc-store");
        this.sharedAttributeResolver.put("batch-size", "jdbc-store");
        this.sharedAttributeResolver.put("fetch-size", "jdbc-store");
        this.sharedAttributeResolver.put("prefix", "jdbc-store");
        this.sharedAttributeResolver.put("id-column.column", "jdbc-store");
        this.sharedAttributeResolver.put("data-column.column", "jdbc-store");
        this.sharedAttributeResolver.put("timestamp-column.column", "jdbc-store");
        this.sharedAttributeResolver.put("entry-tabletable", "jdbc-store");
        this.sharedAttributeResolver.put("bucket-tabletable", "jdbc-store");
        this.sharedAttributeResolver.put("average-read-time", "cache");
        this.sharedAttributeResolver.put("average-remove-time", "cache");
        this.sharedAttributeResolver.put("average-write-time", "cache");
        this.sharedAttributeResolver.put("cache-name", "cache");
        this.sharedAttributeResolver.put("cache-status", "cache");
        this.sharedAttributeResolver.put("commits", "cache");
        this.sharedAttributeResolver.put("concurrency-level", "cache");
        this.sharedAttributeResolver.put("evictions", "cache");
        this.sharedAttributeResolver.put("time-since-start", "cache");
        this.sharedAttributeResolver.put("hit-ratio", "cache");
        this.sharedAttributeResolver.put("hits", "cache");
        this.sharedAttributeResolver.put("invalidations", "cache");
        this.sharedAttributeResolver.put("misses", "cache");
        this.sharedAttributeResolver.put("sites-mixed", "cache");
        this.sharedAttributeResolver.put("number-of-entries", "cache");
        this.sharedAttributeResolver.put("number-of-locks-available", "cache");
        this.sharedAttributeResolver.put("number-of-locks-held", "cache");
        this.sharedAttributeResolver.put("off-heap-memory-used", "cache");
        this.sharedAttributeResolver.put("sites-offline", "cache");
        this.sharedAttributeResolver.put("sites-online", "cache");
        this.sharedAttributeResolver.put("prepares", "cache");
        this.sharedAttributeResolver.put("read-write-ratio", "cache");
        this.sharedAttributeResolver.put("remove-hits", "cache");
        this.sharedAttributeResolver.put("remove-misses", "cache");
        this.sharedAttributeResolver.put("rollbacks", "cache");
        this.sharedAttributeResolver.put("stores", "cache");
        this.sharedAttributeResolver.put("time-since-reset", "cache");
        this.sharedAttributeResolver.put("version", "cache");
        this.sharedAttributeResolver.put("average-replication-time", "clustered-cache");
        this.sharedAttributeResolver.put("replication-count", "clustered-cache");
        this.sharedAttributeResolver.put("replication-failures", "clustered-cache");
        this.sharedAttributeResolver.put("success-ratio", "clustered-cache");
        this.sharedAttributeResolver.put("activations", "loader");
        this.sharedAttributeResolver.put("cache-loader-loads", "loader");
        this.sharedAttributeResolver.put("cache-loader-misses", "loader");
        this.sharedAttributeResolver.put("cache-loader-stores", "loader");
        this.sharedAttributeResolver.put("passivations", "loader");
        this.sharedAttributeResolver.put("transport", null);
        this.sharedAttributeResolver.put("security", "cache");
        this.sharedAttributeResolver.put("locking", null);
        this.sharedAttributeResolver.put("transaction", null);
        this.sharedAttributeResolver.put("memory", null);
        this.sharedAttributeResolver.put("eviction", null);
        this.sharedAttributeResolver.put("expiration", null);
        this.sharedAttributeResolver.put("indexing", null);
        this.sharedAttributeResolver.put("state-transfer", null);
        this.sharedAttributeResolver.put("partition-handling", null);
        this.sharedAttributeResolver.put("backup", null);
        this.sharedAttributeResolver.put("loader", null);
        this.sharedAttributeResolver.put("compatibility", null);
        this.sharedAttributeResolver.put("cluster-loader", null);
        this.sharedAttributeResolver.put("store", null);
        this.sharedAttributeResolver.put("file-store", null);
        this.sharedAttributeResolver.put("remote-store", null);
        this.sharedAttributeResolver.put("rest-store", null);
        this.sharedAttributeResolver.put("string-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("write-behind", null);
        this.sharedAttributeResolver.put("property", null);
        this.sharedAttributeResolver.put("rocksdb-store", null);
        this.sharedAttributeResolver.put("thread-pool", null);
        for (ClusteredCacheMetricsHandler.ClusteredCacheMetrics key : ClusteredCacheMetricsHandler.ClusteredCacheMetrics.values()) {
            this.sharedAttributeResolver.put(key.definition.getName(), "clustered-cache");
        }
    }
}

