/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

import java.nio.ByteBuffer;
import org.rocksdb.Comparator;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.Slice;

public class BytewiseComparator
extends Comparator {
    public BytewiseComparator(ComparatorOptions comparatorOptions) {
        super(comparatorOptions);
    }

    @Override
    public String name() {
        return "rocksdb.java.BytewiseComparator";
    }

    @Override
    public int compare(Slice slice, Slice slice2) {
        return BytewiseComparator.compare((byte[])slice.data(), (byte[])slice2.data());
    }

    @Override
    public String findShortestSeparator(String string, Slice slice) {
        byte by;
        int n;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = (byte[])slice.data();
        int n2 = Math.min(byArray.length, slice.size());
        for (n = 0; n < n2 && byArray[n] == byArray2[n]; ++n) {
        }
        if (n < n2 && (by = byArray[n]) < 255 && by + 1 < byArray2[n]) {
            byte[] byArray3 = new byte[n + 1];
            System.arraycopy(byArray, 0, byArray3, 0, n + 1);
            int n3 = n;
            byArray3[n3] = (byte)(byArray3[n3] + 1);
            assert (BytewiseComparator.compare(byArray3, byArray2) < 0);
            return new String(byArray3);
        }
        return null;
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        return ByteBuffer.wrap(byArray).compareTo(ByteBuffer.wrap(byArray2));
    }

    @Override
    public String findShortSuccessor(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 255) continue;
            byte[] byArray2 = new byte[i + 1];
            System.arraycopy(byArray, 0, byArray2, 0, i + 1);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] + 1);
            return new String(byArray2);
        }
        return null;
    }
}

