/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.embedded.netty4.NettyRestServer;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class EndpointUtils {
    public static ServiceName getCacheServiceName(String cacheContainerName, String cacheName) {
        if (cacheName != null) {
            return CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName);
        }
        return CacheServiceName.CACHE.getServiceName(cacheContainerName);
    }

    public static ServiceName getCacheContainerServiceName(String cacheContainerName) {
        return CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName);
    }

    public static ServiceName getServiceName(ModelNode node, String ... prefix) {
        PathAddress address = PathAddress.pathAddress((ModelNode)node.require("address"));
        String name = address.getLastElement().getValue();
        if (prefix.length > 0) {
            return Constants.DATAGRID.append(prefix).append(new String[]{name});
        }
        return Constants.DATAGRID.append(new String[]{name});
    }

    public static void addCacheDependency(ServiceBuilder<?> builder, String cacheContainerName, String cacheName) {
        ServiceName cacheServiceName = EndpointUtils.getCacheServiceName(cacheContainerName, cacheName);
        builder.addDependency(cacheServiceName);
    }

    public static void addCacheContainerConfigurationDependency(ServiceBuilder<?> builder, String cacheContainerName, InjectedValue<GlobalConfiguration> target) {
        ServiceName cacheContainerConfigurationServiceName = CacheContainerServiceName.CONFIGURATION.getServiceName(cacheContainerName);
        builder.addDependency(cacheContainerConfigurationServiceName, GlobalConfiguration.class, target);
    }

    public static void addCacheContainerDependency(ServiceBuilder<?> builder, String cacheContainerName, InjectedValue<EmbeddedCacheManager> target) {
        ServiceName cacheContainerServiceName = EndpointUtils.getCacheContainerServiceName(cacheContainerName);
        builder.addDependency(cacheContainerServiceName, EmbeddedCacheManager.class, target);
    }

    public static void addHotRodDependency(ServiceBuilder<?> builder, String protocolServerName, InjectedValue<HotRodServer> target) {
        ServiceName protocolServerServiceName = Constants.DATAGRID.append(new String[]{"hotrod"}).append(new String[]{protocolServerName});
        builder.addDependency(protocolServerServiceName, HotRodServer.class, target);
    }

    public static void addRestDependency(ServiceBuilder<?> builder, String protocolServerName, InjectedValue<NettyRestServer> target) {
        ServiceName protocolServerServiceName = Constants.DATAGRID.append(new String[]{"rest"}).append(new String[]{protocolServerName});
        builder.addDependency(protocolServerServiceName, NettyRestServer.class, target);
    }

    public static void addSocketBindingDependency(ServiceBuilder<?> builder, String socketBindingName, InjectedValue<SocketBinding> target) {
        if (socketBindingName != null) {
            ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName});
            builder.addDependency(socketName, SocketBinding.class, target);
        }
    }

    public static void addSecurityDomainDependency(ServiceBuilder<?> builder, String securityDomainName, InjectedValue<SecurityDomainContext> target) {
        ServiceName securityDomainServiceName = SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName});
        builder.addDependency(securityDomainServiceName, SecurityDomainContext.class, target);
    }

    public static void addSecurityRealmDependency(ServiceBuilder<?> builder, String securityRealmName, InjectedValue<SecurityRealm> target) {
        ServiceName securityRealmServiceName = SecurityRealm.ServiceUtil.createServiceName((String)securityRealmName);
        builder.addDependency(securityRealmServiceName, SecurityRealm.class, target);
    }

    public static ModelNode pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress((PathElement[])elements).toModelNode();
    }

    public static void copyIfSet(String name, ModelNode source, ModelNode target) {
        if (source.hasDefined(name)) {
            target.get(name).set(source.get(name));
        }
    }

    public static void addServerSecurityManagerDependency(ServiceBuilder<?> builder, InjectedValue<ServerSecurityManager> serverSecurityManager) {
        builder.addDependency(SimpleSecurityManagerService.SERVICE_NAME, ServerSecurityManager.class, serverSecurityManager);
    }
}

