/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.rest.embedded.netty4.NettyRestServer;
import org.infinispan.rest.embedded.netty4.security.BasicAuthenticator;
import org.infinispan.rest.embedded.netty4.security.ClientCertAuthenticator;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EncryptableServiceHelper;
import org.infinispan.server.endpoint.subsystem.RestAuthMethod;
import org.infinispan.server.endpoint.subsystem.security.BasicRestSecurityDomain;
import org.infinispan.server.endpoint.subsystem.security.ClientCertRestSecurityDomain;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;

public class RestService
implements Service<NettyRestServer>,
EncryptableService {
    private static final String DEFAULT_CONTEXT_PATH = "";
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final InjectedValue<SecurityRealm> encryptionSecurityRealm = new InjectedValue();
    private final InjectedValue<SecurityRealm> authenticationSecurityRealm = new InjectedValue();
    private final Map<String, InjectedValue<SecurityRealm>> sniDomains = new HashMap<String, InjectedValue<SecurityRealm>>();
    private final RestAuthMethod authMethod;
    private final ModelNode config;
    private final String serverName;
    private NettyRestServer restServer;
    private boolean clientAuth;

    public RestService(String serverName, ModelNode config, RestAuthMethod authMethod) {
        this.serverName = serverName;
        this.config = config.clone();
        this.authMethod = authMethod;
    }

    private String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        String path = this.config.hasDefined("context-path") ? this.cleanContextPath(this.config.get("context-path").asString()) : DEFAULT_CONTEXT_PATH;
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.name(this.serverName);
        if (this.config.hasDefined("ignored-caches")) {
            Set ignoredCaches = this.config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
            builder.ignoredCaches(ignoredCaches);
        }
        builder.extendedHeaders(this.config.hasDefined("extended-headers") ? ExtendedHeaders.valueOf((String)this.config.get("extended-headers").asString()) : ExtendedHeaders.ON_DEMAND);
        EncryptableServiceHelper.fillSecurityConfiguration(this, builder.ssl());
        String protocolName = this.getProtocolName();
        EndpointLogger.ROOT_LOGGER.endpointStarting(protocolName);
        try {
            ClientCertAuthenticator authenticator;
            SocketBinding socketBinding = (SocketBinding)this.getSocketBinding().getOptionalValue();
            if (socketBinding == null) {
                builder.startTransport(false);
                EndpointLogger.ROOT_LOGGER.startingServerWithoutTransport("REST");
            } else {
                InetSocketAddress socketAddress = socketBinding.getSocketAddress();
                builder.host(socketAddress.getAddress().getHostAddress());
                builder.port(socketAddress.getPort());
            }
            switch (this.authMethod) {
                case BASIC: {
                    SecurityRealm authenticationRealm = (SecurityRealm)this.authenticationSecurityRealm.getOptionalValue();
                    BasicRestSecurityDomain restSecurityDomain = new BasicRestSecurityDomain(authenticationRealm);
                    authenticator = new BasicAuthenticator((SecurityDomain)restSecurityDomain, EncryptableServiceHelper.isSecurityEnabled(this), authenticationRealm.getName());
                    break;
                }
                case CLIENT_CERT: {
                    if (!EncryptableServiceHelper.isSecurityEnabled(this)) {
                        throw EndpointLogger.ROOT_LOGGER.cannotUseCertificateAuthenticationWithoutEncryption();
                    }
                    SecurityRealm authenticationRealm = (SecurityRealm)this.authenticationSecurityRealm.getOptionalValue();
                    ClientCertRestSecurityDomain restSecurityDomain = new ClientCertRestSecurityDomain(authenticationRealm);
                    authenticator = new ClientCertAuthenticator((SecurityDomain)restSecurityDomain);
                    break;
                }
                case NONE: {
                    authenticator = null;
                    break;
                }
                default: {
                    throw EndpointLogger.ROOT_LOGGER.restAuthMethodUnsupported(this.authMethod.toString());
                }
            }
            this.restServer = NettyRestServer.createServer((RestServerConfiguration)builder.build(), (EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagerInjector.getValue()), authenticator);
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextCreationFailed(e);
        }
        try {
            this.restServer.start();
            EndpointLogger.ROOT_LOGGER.httpEndpointStarted(protocolName, path, "rest");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextStartFailed(e);
        }
    }

    private String getProtocolName() {
        return EncryptableServiceHelper.isSecurityEnabled(this) ? (EncryptableServiceHelper.isSniEnabled(this) ? this.serverName + "+SNI" : this.serverName + "+SSL") : this.serverName;
    }

    public synchronized void stop(StopContext stopContext) {
        this.restServer.stop();
    }

    public synchronized NettyRestServer getValue() throws IllegalStateException {
        if (this.restServer == null) {
            throw new IllegalStateException();
        }
        return this.restServer;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<SecurityRealm> getAuthenticationSecurityRealm() {
        return this.authenticationSecurityRealm;
    }

    public InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }

    @Override
    public InjectedValue<SecurityRealm> getEncryptionSecurityRealm() {
        return this.encryptionSecurityRealm;
    }

    @Override
    public InjectedValue<SecurityRealm> getSniSecurityRealm(String sniHostName) {
        return this.sniDomains.computeIfAbsent(sniHostName, v -> new InjectedValue());
    }

    @Override
    public Map<String, InjectedValue<SecurityRealm>> getSniConfiguration() {
        return this.sniDomains;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setClientAuth(boolean enabled) {
        this.clientAuth = enabled;
    }

    @Override
    public boolean getClientAuth() {
        return this.clientAuth;
    }
}

