/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Optional;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.MultiTenantRouterService;
import org.infinispan.server.endpoint.subsystem.PrefixResource;
import org.infinispan.server.endpoint.subsystem.RouterConnectorResource;
import org.infinispan.server.endpoint.subsystem.RouterHotRodResource;
import org.infinispan.server.endpoint.subsystem.RouterRestResource;
import org.infinispan.server.endpoint.subsystem.SniResource;
import org.infinispan.server.router.configuration.builder.MultiTenantRouterConfigurationBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class RouterSubsystemAdd
extends AbstractAddStepHandler {
    static final RouterSubsystemAdd INSTANCE = new RouterSubsystemAdd();

    RouterSubsystemAdd() {
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition attr : RouterConnectorResource.ROUTER_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MultiTenantRouterConfigurationBuilder configuration = new MultiTenantRouterConfigurationBuilder();
        MultiTenantRouterService routerService = new MultiTenantRouterService(configuration, this.getServiceName(config));
        ServiceName MultitenantRouterServiceName = EndpointUtils.getServiceName(operation, "router");
        ServiceBuilder builder = context.getServiceTarget().addService(MultitenantRouterServiceName, (Service)routerService);
        EndpointUtils.addSocketBindingDependency(builder, operation.get("hotrod-socket-binding").asString(), routerService.getHotrodSocketBinding());
        EndpointUtils.addSocketBindingDependency(builder, operation.get("rest-socket-binding").asString(), routerService.getRestSocketBinding());
        ModelNode multiTenancyInnerConfiguration = config.get(new String[]{"multi-tenancy", "MULTI_TENANCY"});
        this.addHotRod(context, multiTenancyInnerConfiguration, routerService, builder);
        this.addRest(context, multiTenancyInnerConfiguration, routerService, builder);
        builder.install();
    }

    private void addRest(OperationContext context, ModelNode config, MultiTenantRouterService routerService, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.get("rest").isDefined()) {
            for (ModelNode r : config.get("rest").asList()) {
                ModelNode restNode = r.get(0);
                String restName = RouterRestResource.NAME.resolveModelAttribute(context, restNode).asString();
                if (!restNode.get("prefix").isDefined()) continue;
                for (ModelNode prefixNode : restNode.get("prefix").asList()) {
                    String pathPrefix = PrefixResource.PATH.resolveModelAttribute(context, prefixNode.get(0)).asString();
                    MultiTenantRouterService.RestRouting restRouting = routerService.getRestRouting(pathPrefix, restName);
                    EndpointUtils.addRestDependency(builder, restName, restRouting.getRest());
                }
            }
        }
    }

    private void addHotRod(OperationContext context, ModelNode config, MultiTenantRouterService routerService, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.get("hotrod").isDefined()) {
            for (ModelNode hr : config.get("hotrod").asList()) {
                ModelNode hotRod = hr.get(0);
                String hotRodName = RouterHotRodResource.NAME.resolveModelAttribute(context, hotRod).asString();
                routerService.tcpNoDelay(RouterConnectorResource.TCP_NODELAY.resolveModelAttribute(context, hotRod).asBoolean());
                routerService.keepAlive(RouterConnectorResource.KEEP_ALIVE.resolveModelAttribute(context, hotRod).asBoolean());
                routerService.sendBufferSize(RouterConnectorResource.SEND_BUFFER_SIZE.resolveModelAttribute(context, hotRod).asInt());
                routerService.receiveBufferSize(RouterConnectorResource.RECEIVE_BUFFER_SIZE.resolveModelAttribute(context, hotRod).asInt());
                if (!hotRod.get("sni").isDefined()) continue;
                for (ModelNode sni : hotRod.get("sni").asList()) {
                    ModelNode sniNode = sni.get(0);
                    String sniHostName = SniResource.HOST_NAME.resolveModelAttribute(context, sniNode).asString();
                    String securityRealm = SniResource.SECURITY_REALM.resolveModelAttribute(context, sniNode).asString();
                    MultiTenantRouterService.HotRodRouting hotRodRouting = routerService.getHotRodRouting(sniHostName);
                    EndpointUtils.addHotRodDependency(builder, hotRodName, hotRodRouting.getHotRod());
                    EndpointUtils.addSecurityRealmDependency(builder, securityRealm, hotRodRouting.getSecurityRealm());
                }
            }
        }
    }

    private Optional<String> getServiceName(ModelNode config) {
        return Optional.ofNullable(config.get("name")).map(ModelNode::asString);
    }
}

