/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.rocksdb.MutableColumnFamilyOptionsInterface;

public class MutableColumnFamilyOptions {
    private static final String KEY_VALUE_PAIR_SEPARATOR = ";";
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final String INT_ARRAY_INT_SEPARATOR = ",";
    private final String[] keys;
    private final String[] values;

    private MutableColumnFamilyOptions(String[] stringArray, String[] stringArray2) {
        this.keys = stringArray;
        this.values = stringArray2;
    }

    String[] getKeys() {
        return this.keys;
    }

    String[] getValues() {
        return this.values;
    }

    public static MutableColumnFamilyOptionsBuilder builder() {
        return new MutableColumnFamilyOptionsBuilder();
    }

    public static MutableColumnFamilyOptionsBuilder parse(String string) {
        String[] stringArray;
        Objects.requireNonNull(string);
        MutableColumnFamilyOptionsBuilder mutableColumnFamilyOptionsBuilder = new MutableColumnFamilyOptionsBuilder();
        for (String string2 : stringArray = string.trim().split(KEY_VALUE_PAIR_SEPARATOR)) {
            int n = string2.indexOf(61);
            if (n <= 0) {
                throw new IllegalArgumentException("options string has an invalid key=value pair");
            }
            String string3 = string2.substring(0, n);
            if (string3 == null || string3.isEmpty()) {
                throw new IllegalArgumentException("options string is invalid");
            }
            String string4 = string2.substring(n + 1);
            if (string4 == null || string4.isEmpty()) {
                throw new IllegalArgumentException("options string is invalid");
            }
            mutableColumnFamilyOptionsBuilder.fromString(string3, string4);
        }
        return mutableColumnFamilyOptionsBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.keys.length; ++i) {
            stringBuilder.append(this.keys[i]).append('=').append(this.values[i]);
            if (i + 1 >= this.keys.length) continue;
            stringBuilder.append(KEY_VALUE_PAIR_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static class MutableColumnFamilyOptionsBuilder
    implements MutableColumnFamilyOptionsInterface {
        private static final Map<String, MutableColumnFamilyOptionKey> ALL_KEYS_LOOKUP = new HashMap<String, MutableColumnFamilyOptionKey>();
        private final Map<MutableColumnFamilyOptionKey, MutableColumnFamilyOptionValue<?>> options = new LinkedHashMap();

        public MutableColumnFamilyOptions build() {
            String[] stringArray = new String[this.options.size()];
            String[] stringArray2 = new String[this.options.size()];
            int n = 0;
            for (Map.Entry<MutableColumnFamilyOptionKey, MutableColumnFamilyOptionValue<?>> entry : this.options.entrySet()) {
                stringArray[n] = entry.getKey().name();
                stringArray2[n] = entry.getValue().asString();
                ++n;
            }
            return new MutableColumnFamilyOptions(stringArray, stringArray2);
        }

        private MutableColumnFamilyOptionsBuilder setDouble(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey, double d) {
            if (mutableColumnFamilyOptionKey.getValueType() != ValueType.DOUBLE) {
                throw new IllegalArgumentException(mutableColumnFamilyOptionKey + " does not accept a double value");
            }
            this.options.put(mutableColumnFamilyOptionKey, new MutableColumnFamilyOptionDoubleValue(d));
            return this;
        }

        private double getDouble(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey) throws NoSuchElementException, NumberFormatException {
            MutableColumnFamilyOptionValue<?> mutableColumnFamilyOptionValue = this.options.get(mutableColumnFamilyOptionKey);
            if (mutableColumnFamilyOptionValue == null) {
                throw new NoSuchElementException(mutableColumnFamilyOptionKey.name() + " has not been set");
            }
            return mutableColumnFamilyOptionValue.asDouble();
        }

        private MutableColumnFamilyOptionsBuilder setLong(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey, long l) {
            if (mutableColumnFamilyOptionKey.getValueType() != ValueType.LONG) {
                throw new IllegalArgumentException(mutableColumnFamilyOptionKey + " does not accept a long value");
            }
            this.options.put(mutableColumnFamilyOptionKey, new MutableColumnFamilyOptionLongValue(l));
            return this;
        }

        private long getLong(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey) throws NoSuchElementException, NumberFormatException {
            MutableColumnFamilyOptionValue<?> mutableColumnFamilyOptionValue = this.options.get(mutableColumnFamilyOptionKey);
            if (mutableColumnFamilyOptionValue == null) {
                throw new NoSuchElementException(mutableColumnFamilyOptionKey.name() + " has not been set");
            }
            return mutableColumnFamilyOptionValue.asLong();
        }

        private MutableColumnFamilyOptionsBuilder setInt(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey, int n) {
            if (mutableColumnFamilyOptionKey.getValueType() != ValueType.INT) {
                throw new IllegalArgumentException(mutableColumnFamilyOptionKey + " does not accept an integer value");
            }
            this.options.put(mutableColumnFamilyOptionKey, new MutableColumnFamilyOptionIntValue(n));
            return this;
        }

        private int getInt(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey) throws NoSuchElementException, NumberFormatException {
            MutableColumnFamilyOptionValue<?> mutableColumnFamilyOptionValue = this.options.get(mutableColumnFamilyOptionKey);
            if (mutableColumnFamilyOptionValue == null) {
                throw new NoSuchElementException(mutableColumnFamilyOptionKey.name() + " has not been set");
            }
            return mutableColumnFamilyOptionValue.asInt();
        }

        private MutableColumnFamilyOptionsBuilder setBoolean(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey, boolean bl) {
            if (mutableColumnFamilyOptionKey.getValueType() != ValueType.BOOLEAN) {
                throw new IllegalArgumentException(mutableColumnFamilyOptionKey + " does not accept a boolean value");
            }
            this.options.put(mutableColumnFamilyOptionKey, new MutableColumnFamilyOptionBooleanValue(bl));
            return this;
        }

        private boolean getBoolean(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey) throws NoSuchElementException, NumberFormatException {
            MutableColumnFamilyOptionValue<?> mutableColumnFamilyOptionValue = this.options.get(mutableColumnFamilyOptionKey);
            if (mutableColumnFamilyOptionValue == null) {
                throw new NoSuchElementException(mutableColumnFamilyOptionKey.name() + " has not been set");
            }
            return mutableColumnFamilyOptionValue.asBoolean();
        }

        private MutableColumnFamilyOptionsBuilder setIntArray(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey, int[] nArray) {
            if (mutableColumnFamilyOptionKey.getValueType() != ValueType.INT_ARRAY) {
                throw new IllegalArgumentException(mutableColumnFamilyOptionKey + " does not accept an int array value");
            }
            this.options.put(mutableColumnFamilyOptionKey, new MutableColumnFamilyOptionIntArrayValue(nArray));
            return this;
        }

        private int[] getIntArray(MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey) throws NoSuchElementException, NumberFormatException {
            MutableColumnFamilyOptionValue<?> mutableColumnFamilyOptionValue = this.options.get(mutableColumnFamilyOptionKey);
            if (mutableColumnFamilyOptionValue == null) {
                throw new NoSuchElementException(mutableColumnFamilyOptionKey.name() + " has not been set");
            }
            return mutableColumnFamilyOptionValue.asIntArray();
        }

        public MutableColumnFamilyOptionsBuilder fromString(String string, String string2) throws IllegalArgumentException {
            Objects.requireNonNull(string);
            Objects.requireNonNull(string2);
            MutableColumnFamilyOptionKey mutableColumnFamilyOptionKey = ALL_KEYS_LOOKUP.get(string);
            switch (mutableColumnFamilyOptionKey.getValueType()) {
                case DOUBLE: {
                    return this.setDouble(mutableColumnFamilyOptionKey, Double.parseDouble(string2));
                }
                case LONG: {
                    return this.setLong(mutableColumnFamilyOptionKey, Long.parseLong(string2));
                }
                case INT: {
                    return this.setInt(mutableColumnFamilyOptionKey, Integer.parseInt(string2));
                }
                case BOOLEAN: {
                    return this.setBoolean(mutableColumnFamilyOptionKey, Boolean.parseBoolean(string2));
                }
                case INT_ARRAY: {
                    String[] stringArray = string2.trim().split(MutableColumnFamilyOptions.INT_ARRAY_INT_SEPARATOR);
                    if (stringArray == null || stringArray.length == 0) {
                        throw new IllegalArgumentException("int array value is not correctly formatted");
                    }
                    int[] nArray = new int[stringArray.length];
                    int n = 0;
                    for (String string3 : stringArray) {
                        nArray[n++] = Integer.parseInt(string3);
                    }
                    return this.setIntArray(mutableColumnFamilyOptionKey, nArray);
                }
            }
            throw new IllegalStateException(mutableColumnFamilyOptionKey + " has unknown value type: " + (Object)((Object)mutableColumnFamilyOptionKey.getValueType()));
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setWriteBufferSize(long l) {
            return this.setLong(MemtableOption.write_buffer_size, l);
        }

        @Override
        public long writeBufferSize() {
            return this.getLong(MemtableOption.write_buffer_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setArenaBlockSize(long l) {
            return this.setLong(MemtableOption.arena_block_size, l);
        }

        @Override
        public long arenaBlockSize() {
            return this.getLong(MemtableOption.arena_block_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMemtablePrefixBloomSizeRatio(double d) {
            return this.setDouble(MemtableOption.memtable_prefix_bloom_size_ratio, d);
        }

        @Override
        public double memtablePrefixBloomSizeRatio() {
            return this.getDouble(MemtableOption.memtable_prefix_bloom_size_ratio);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMemtableHugePageSize(long l) {
            return this.setLong(MemtableOption.memtable_huge_page_size, l);
        }

        @Override
        public long memtableHugePageSize() {
            return this.getLong(MemtableOption.memtable_huge_page_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxSuccessiveMerges(long l) {
            return this.setLong(MemtableOption.max_successive_merges, l);
        }

        @Override
        public long maxSuccessiveMerges() {
            return this.getLong(MemtableOption.max_successive_merges);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxWriteBufferNumber(int n) {
            return this.setInt(MemtableOption.max_write_buffer_number, n);
        }

        @Override
        public int maxWriteBufferNumber() {
            return this.getInt(MemtableOption.max_write_buffer_number);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setInplaceUpdateNumLocks(long l) {
            return this.setLong(MemtableOption.inplace_update_num_locks, l);
        }

        @Override
        public long inplaceUpdateNumLocks() {
            return this.getLong(MemtableOption.inplace_update_num_locks);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setDisableAutoCompactions(boolean bl) {
            return this.setBoolean(CompactionOption.disable_auto_compactions, bl);
        }

        @Override
        public boolean disableAutoCompactions() {
            return this.getBoolean(CompactionOption.disable_auto_compactions);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setSoftRateLimit(double d) {
            return this.setDouble(CompactionOption.soft_rate_limit, d);
        }

        @Override
        public double softRateLimit() {
            return this.getDouble(CompactionOption.soft_rate_limit);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setSoftPendingCompactionBytesLimit(long l) {
            return this.setLong(CompactionOption.soft_pending_compaction_bytes_limit, l);
        }

        @Override
        public long softPendingCompactionBytesLimit() {
            return this.getLong(CompactionOption.soft_pending_compaction_bytes_limit);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setHardRateLimit(double d) {
            return this.setDouble(CompactionOption.hard_rate_limit, d);
        }

        @Override
        public double hardRateLimit() {
            return this.getDouble(CompactionOption.hard_rate_limit);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setHardPendingCompactionBytesLimit(long l) {
            return this.setLong(CompactionOption.hard_pending_compaction_bytes_limit, l);
        }

        @Override
        public long hardPendingCompactionBytesLimit() {
            return this.getLong(CompactionOption.hard_pending_compaction_bytes_limit);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setLevel0FileNumCompactionTrigger(int n) {
            return this.setInt(CompactionOption.level0_file_num_compaction_trigger, n);
        }

        @Override
        public int level0FileNumCompactionTrigger() {
            return this.getInt(CompactionOption.level0_file_num_compaction_trigger);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setLevel0SlowdownWritesTrigger(int n) {
            return this.setInt(CompactionOption.level0_slowdown_writes_trigger, n);
        }

        @Override
        public int level0SlowdownWritesTrigger() {
            return this.getInt(CompactionOption.level0_slowdown_writes_trigger);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setLevel0StopWritesTrigger(int n) {
            return this.setInt(CompactionOption.level0_stop_writes_trigger, n);
        }

        @Override
        public int level0StopWritesTrigger() {
            return this.getInt(CompactionOption.level0_stop_writes_trigger);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxCompactionBytes(long l) {
            return this.setLong(CompactionOption.max_compaction_bytes, l);
        }

        @Override
        public long maxCompactionBytes() {
            return this.getLong(CompactionOption.max_compaction_bytes);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setTargetFileSizeBase(long l) {
            return this.setLong(CompactionOption.target_file_size_base, l);
        }

        @Override
        public long targetFileSizeBase() {
            return this.getLong(CompactionOption.target_file_size_base);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setTargetFileSizeMultiplier(int n) {
            return this.setInt(CompactionOption.target_file_size_multiplier, n);
        }

        @Override
        public int targetFileSizeMultiplier() {
            return this.getInt(CompactionOption.target_file_size_multiplier);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelBase(long l) {
            return this.setLong(CompactionOption.max_bytes_for_level_base, l);
        }

        @Override
        public long maxBytesForLevelBase() {
            return this.getLong(CompactionOption.max_bytes_for_level_base);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelMultiplier(double d) {
            return this.setDouble(CompactionOption.max_bytes_for_level_multiplier, d);
        }

        @Override
        public double maxBytesForLevelMultiplier() {
            return this.getDouble(CompactionOption.max_bytes_for_level_multiplier);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelMultiplierAdditional(int[] nArray) {
            return this.setIntArray(CompactionOption.max_bytes_for_level_multiplier_additional, nArray);
        }

        @Override
        public int[] maxBytesForLevelMultiplierAdditional() {
            return this.getIntArray(CompactionOption.max_bytes_for_level_multiplier_additional);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setVerifyChecksumsInCompaction(boolean bl) {
            return this.setBoolean(CompactionOption.verify_checksums_in_compaction, bl);
        }

        @Override
        public boolean verifyChecksumsInCompaction() {
            return this.getBoolean(CompactionOption.verify_checksums_in_compaction);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxSequentialSkipInIterations(long l) {
            return this.setLong(MiscOption.max_sequential_skip_in_iterations, l);
        }

        @Override
        public long maxSequentialSkipInIterations() {
            return this.getLong(MiscOption.max_sequential_skip_in_iterations);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setParanoidFileChecks(boolean bl) {
            return this.setBoolean(MiscOption.paranoid_file_checks, bl);
        }

        @Override
        public boolean paranoidFileChecks() {
            return this.getBoolean(MiscOption.paranoid_file_checks);
        }

        static {
            for (MemtableOption enum_ : MemtableOption.values()) {
                ALL_KEYS_LOOKUP.put(enum_.name(), enum_);
            }
            for (Enum enum_ : CompactionOption.values()) {
                ALL_KEYS_LOOKUP.put(enum_.name(), (MutableColumnFamilyOptionKey)((Object)enum_));
            }
            for (Enum enum_ : MiscOption.values()) {
                ALL_KEYS_LOOKUP.put(enum_.name(), (MutableColumnFamilyOptionKey)((Object)enum_));
            }
        }
    }

    private static class MutableColumnFamilyOptionIntArrayValue
    extends MutableColumnFamilyOptionValue<int[]> {
        MutableColumnFamilyOptionIntArrayValue(int[] nArray) {
            super(nArray);
        }

        @Override
        double asDouble() {
            throw new NumberFormatException("int[] is not applicable as double");
        }

        @Override
        long asLong() throws NumberFormatException {
            throw new NumberFormatException("int[] is not applicable as Long");
        }

        @Override
        int asInt() throws NumberFormatException {
            throw new NumberFormatException("int[] is not applicable as int");
        }

        @Override
        boolean asBoolean() {
            throw new NumberFormatException("int[] is not applicable as boolean");
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            return (int[])this.value;
        }

        @Override
        String asString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((int[])this.value).length; ++i) {
                stringBuilder.append(Integer.toString(i));
                if (i + 1 >= ((int[])this.value).length) continue;
                stringBuilder.append(MutableColumnFamilyOptions.INT_ARRAY_INT_SEPARATOR);
            }
            return stringBuilder.toString();
        }
    }

    private static class MutableColumnFamilyOptionBooleanValue
    extends MutableColumnFamilyOptionValue<Boolean> {
        MutableColumnFamilyOptionBooleanValue(boolean bl) {
            super(bl);
        }

        @Override
        double asDouble() {
            throw new NumberFormatException("boolean is not applicable as double");
        }

        @Override
        long asLong() throws NumberFormatException {
            throw new NumberFormatException("boolean is not applicable as Long");
        }

        @Override
        int asInt() throws NumberFormatException {
            throw new NumberFormatException("boolean is not applicable as int");
        }

        @Override
        boolean asBoolean() {
            return (Boolean)this.value;
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            throw new IllegalStateException("boolean is not applicable as int[]");
        }

        @Override
        String asString() {
            return Boolean.toString((Boolean)this.value);
        }
    }

    private static class MutableColumnFamilyOptionIntValue
    extends MutableColumnFamilyOptionValue<Integer> {
        MutableColumnFamilyOptionIntValue(int n) {
            super(n);
        }

        @Override
        double asDouble() {
            if ((double)((Integer)this.value).intValue() > Double.MAX_VALUE || (double)((Integer)this.value).intValue() < Double.MIN_VALUE) {
                throw new NumberFormatException("int value lies outside the bounds of int");
            }
            return ((Integer)this.value).doubleValue();
        }

        @Override
        long asLong() throws NumberFormatException {
            return ((Integer)this.value).intValue();
        }

        @Override
        int asInt() throws NumberFormatException {
            return (Integer)this.value;
        }

        @Override
        boolean asBoolean() throws IllegalStateException {
            throw new IllegalStateException("int is not applicable as boolean");
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            return new int[]{(Integer)this.value};
        }

        @Override
        String asString() {
            return Integer.toString((Integer)this.value);
        }
    }

    private static class MutableColumnFamilyOptionLongValue
    extends MutableColumnFamilyOptionValue<Long> {
        MutableColumnFamilyOptionLongValue(long l) {
            super(l);
        }

        @Override
        double asDouble() {
            if ((double)((Long)this.value).longValue() > Double.MAX_VALUE || (double)((Long)this.value).longValue() < Double.MIN_VALUE) {
                throw new NumberFormatException("long value lies outside the bounds of int");
            }
            return ((Long)this.value).doubleValue();
        }

        @Override
        long asLong() throws NumberFormatException {
            return (Long)this.value;
        }

        @Override
        int asInt() throws NumberFormatException {
            if ((Long)this.value > Integer.MAX_VALUE || (Long)this.value < Integer.MIN_VALUE) {
                throw new NumberFormatException("long value lies outside the bounds of int");
            }
            return ((Long)this.value).intValue();
        }

        @Override
        boolean asBoolean() throws IllegalStateException {
            throw new IllegalStateException("long is not applicable as boolean");
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            if ((Long)this.value > Integer.MAX_VALUE || (Long)this.value < Integer.MIN_VALUE) {
                throw new NumberFormatException("long value lies outside the bounds of int");
            }
            return new int[]{((Long)this.value).intValue()};
        }

        @Override
        String asString() {
            return Long.toString((Long)this.value);
        }
    }

    private static class MutableColumnFamilyOptionDoubleValue
    extends MutableColumnFamilyOptionValue<Double> {
        MutableColumnFamilyOptionDoubleValue(double d) {
            super(d);
        }

        @Override
        double asDouble() {
            return (Double)this.value;
        }

        @Override
        long asLong() throws NumberFormatException {
            return ((Double)this.value).longValue();
        }

        @Override
        int asInt() throws NumberFormatException {
            if ((Double)this.value > 2.147483647E9 || (Double)this.value < -2.147483648E9) {
                throw new NumberFormatException("double value lies outside the bounds of int");
            }
            return ((Double)this.value).intValue();
        }

        @Override
        boolean asBoolean() throws IllegalStateException {
            throw new IllegalStateException("double is not applicable as boolean");
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            if ((Double)this.value > 2.147483647E9 || (Double)this.value < -2.147483648E9) {
                throw new NumberFormatException("double value lies outside the bounds of int");
            }
            return new int[]{((Double)this.value).intValue()};
        }

        @Override
        String asString() {
            return Double.toString((Double)this.value);
        }
    }

    private static class MutableColumnFamilyOptionStringValue
    extends MutableColumnFamilyOptionValue<String> {
        MutableColumnFamilyOptionStringValue(String string) {
            super(string);
        }

        @Override
        double asDouble() throws NumberFormatException {
            return Double.parseDouble((String)this.value);
        }

        @Override
        long asLong() throws NumberFormatException {
            return Long.parseLong((String)this.value);
        }

        @Override
        int asInt() throws NumberFormatException {
            return Integer.parseInt((String)this.value);
        }

        @Override
        boolean asBoolean() throws IllegalStateException {
            return Boolean.parseBoolean((String)this.value);
        }

        @Override
        int[] asIntArray() throws IllegalStateException {
            throw new IllegalStateException("String is not applicable as int[]");
        }

        @Override
        String asString() {
            return (String)this.value;
        }
    }

    private static abstract class MutableColumnFamilyOptionValue<T> {
        protected final T value;

        MutableColumnFamilyOptionValue(T t) {
            this.value = t;
        }

        abstract double asDouble() throws NumberFormatException;

        abstract long asLong() throws NumberFormatException;

        abstract int asInt() throws NumberFormatException;

        abstract boolean asBoolean() throws IllegalStateException;

        abstract int[] asIntArray() throws IllegalStateException;

        abstract String asString();
    }

    private static interface MutableColumnFamilyOptionKey {
        public String name();

        public ValueType getValueType();
    }

    public static enum MiscOption implements MutableColumnFamilyOptionKey
    {
        max_sequential_skip_in_iterations(ValueType.LONG),
        paranoid_file_checks(ValueType.BOOLEAN);

        private final ValueType valueType;

        private MiscOption(ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }
    }

    public static enum CompactionOption implements MutableColumnFamilyOptionKey
    {
        disable_auto_compactions(ValueType.BOOLEAN),
        soft_rate_limit(ValueType.DOUBLE),
        soft_pending_compaction_bytes_limit(ValueType.LONG),
        hard_rate_limit(ValueType.DOUBLE),
        hard_pending_compaction_bytes_limit(ValueType.LONG),
        level0_file_num_compaction_trigger(ValueType.INT),
        level0_slowdown_writes_trigger(ValueType.INT),
        level0_stop_writes_trigger(ValueType.INT),
        max_compaction_bytes(ValueType.LONG),
        target_file_size_base(ValueType.LONG),
        target_file_size_multiplier(ValueType.INT),
        max_bytes_for_level_base(ValueType.LONG),
        max_bytes_for_level_multiplier(ValueType.INT),
        max_bytes_for_level_multiplier_additional(ValueType.INT_ARRAY),
        verify_checksums_in_compaction(ValueType.BOOLEAN);

        private final ValueType valueType;

        private CompactionOption(ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }
    }

    public static enum MemtableOption implements MutableColumnFamilyOptionKey
    {
        write_buffer_size(ValueType.LONG),
        arena_block_size(ValueType.LONG),
        memtable_prefix_bloom_size_ratio(ValueType.DOUBLE),
        memtable_prefix_bloom_bits(ValueType.INT),
        memtable_prefix_bloom_probes(ValueType.INT),
        memtable_huge_page_size(ValueType.LONG),
        max_successive_merges(ValueType.LONG),
        filter_deletes(ValueType.BOOLEAN),
        max_write_buffer_number(ValueType.INT),
        inplace_update_num_locks(ValueType.LONG);

        private final ValueType valueType;

        private MemtableOption(ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }
    }

    public static enum ValueType {
        DOUBLE,
        LONG,
        INT,
        BOOLEAN,
        INT_ARRAY;

    }
}

