/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.NioServer;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.GossipType;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class GossipRouter
extends ReceiverAdapter
implements ConnectionListener {
    @ManagedAttribute(description="address to which the GossipRouter should bind", writable=true, name="bind_address")
    protected String bind_addr;
    @ManagedAttribute(description="server port on which the GossipRouter accepts client connections", writable=true)
    protected int port = 12001;
    @ManagedAttribute(description="time (in msecs) until gossip entry expires. 0 disables expiration.", writable=true)
    protected long expiry_time;
    @Property(description="Time (in ms) for setting SO_LINGER on sockets returned from accept(). 0 means do not set SO_LINGER")
    protected long linger_timeout = 2000L;
    @Property(description="Time (in ms) for SO_TIMEOUT on sockets returned from accept(). 0 means don't set SO_TIMEOUT")
    protected long sock_read_timeout;
    protected ThreadFactory thread_factory = new DefaultThreadFactory("gossip", false, true);
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    @Property(description="The max queue size of backlogged connections")
    protected int backlog = 1000;
    @Property(description="Expose GossipRouter via JMX", writable=false)
    protected boolean jmx = true;
    @Property(description="Use non-blocking IO (true) or blocking IO (false). Cannot be changed at runtime", writable=false)
    protected boolean use_nio = true;
    @Property(description="Handles client disconnects: sends SUSPECT message to all other members of that group")
    protected boolean emit_suspect_events = true;
    @Property(description="Dumps messages (dest/src/length/headers to stdout if enabled")
    protected boolean dump_msgs;
    protected BaseServer server;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected Timer timer;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ConcurrentMap<String, ConcurrentMap<Address, Entry>> address_mappings = new ConcurrentHashMap<String, ConcurrentMap<Address, Entry>>();

    public GossipRouter(String bind_addr, int local_port) {
        this.bind_addr = bind_addr;
        this.port = local_port;
    }

    public Address localAddress() {
        return this.server.localAddress();
    }

    public String bindAddress() {
        return this.bind_addr;
    }

    public GossipRouter bindAddress(String addr) {
        this.bind_addr = addr;
        return this;
    }

    public int port() {
        return this.port;
    }

    public GossipRouter port(int port) {
        this.port = port;
        return this;
    }

    public long expiryTime() {
        return this.expiry_time;
    }

    public GossipRouter expiryTime(long t) {
        this.expiry_time = t;
        return this;
    }

    public long lingerTimeout() {
        return this.linger_timeout;
    }

    public GossipRouter lingerTimeout(long t) {
        this.linger_timeout = t;
        return this;
    }

    public long socketReadTimeout() {
        return this.sock_read_timeout;
    }

    public GossipRouter socketReadTimeout(long t) {
        this.sock_read_timeout = t;
        return this;
    }

    public ThreadFactory threadPoolFactory() {
        return this.thread_factory;
    }

    public GossipRouter threadPoolFactory(ThreadFactory f) {
        this.thread_factory = f;
        return this;
    }

    public SocketFactory socketFactory() {
        return this.socket_factory;
    }

    public GossipRouter socketFactory(SocketFactory sf) {
        this.socket_factory = sf;
        return this;
    }

    public int backlog() {
        return this.backlog;
    }

    public GossipRouter backlog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public boolean jmx() {
        return this.jmx;
    }

    public GossipRouter jmx(boolean flag) {
        this.jmx = flag;
        return this;
    }

    public boolean useNio() {
        return this.use_nio;
    }

    public GossipRouter useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public boolean emitSuspectEvents() {
        return this.emit_suspect_events;
    }

    public GossipRouter emitSuspectEvents(boolean flag) {
        this.emit_suspect_events = flag;
        return this;
    }

    public boolean dumpMessages() {
        return this.dump_msgs;
    }

    public GossipRouter dumpMessages(boolean flag) {
        this.dump_msgs = flag;
        return this;
    }

    @ManagedAttribute(description="operational status", name="running")
    public boolean running() {
        return this.running.get();
    }

    @ManagedOperation(description="Lifecycle operation. Called after create(). When this method is called, the managed attributes have already been set. Brings the Router into a fully functional state.")
    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (this.jmx) {
            JmxConfigurator.register(this, Util.getMBeanServer(), "jgroups:name=GossipRouter");
        }
        InetAddress tmp = this.bind_addr != null ? InetAddress.getByName(this.bind_addr) : null;
        this.server = this.use_nio ? new NioServer(this.thread_factory, this.socket_factory, tmp, this.port, this.port, null, 0) : new TcpServer(this.thread_factory, this.socket_factory, tmp, this.port, this.port, null, 0);
        this.server.receiver(this);
        this.server.start();
        this.server.addConnectionListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GossipRouter.this.stop();
            }
        });
    }

    @ManagedOperation(description="Always called before destroy(). Closes connections and frees resources")
    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        try {
            JmxConfigurator.unregister(this, Util.getMBeanServer(), "jgroups:name=GossipRouter");
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("MBeanDeRegistrationFailed"), ex);
        }
        Util.close((Closeable)this.server);
        this.log.debug("router stopped");
    }

    @ManagedOperation(description="Dumps the contents of the routing table")
    public String dumpRoutingTable() {
        return this.server.printConnections();
    }

    @ManagedOperation(description="Dumps the address mappings")
    public String dumpAddresssMappings() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.address_mappings.entrySet()) {
            String group = (String)entry.getKey();
            Map val = (Map)entry.getValue();
            if (val == null) continue;
            sb.append(group).append(":\n");
            for (Map.Entry entry2 : val.entrySet()) {
                Address logical_addr = (Address)entry2.getKey();
                Entry val2 = (Entry)entry2.getValue();
                if (val2 == null) continue;
                sb.append(String.format("  %s: %s (client_addr: %s, uuid:%s)\n", val2.logical_name, val2.phys_addr, val2.client_addr, logical_addr));
            }
        }
        return sb.toString();
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        GossipType type;
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            type = GossipType.values()[in.readByte()];
        }
        catch (Exception ex) {
            this.log.error("failed reading data from %s: %s", sender, ex);
            return;
        }
        GossipData request = null;
        switch (type) {
            case REGISTER: {
                request = this.readRequest(in.position(offset));
                if (request == null) break;
                this.handleRegister(sender, request);
                break;
            }
            case MESSAGE: {
                try {
                    String group = Bits.readString(in);
                    Address dest = Util.readAddress(in);
                    this.route(group, dest, buf, offset, length);
                    if (!this.dump_msgs) break;
                    ByteArrayDataInputStream input = new ByteArrayDataInputStream(buf, offset, length);
                    GossipData data = new GossipData();
                    data.readFrom(input);
                    System.out.println("");
                    List<Message> messages = Util.parse(data.buffer, data.offset, data.length);
                    if (messages == null) break;
                    for (Message msg : messages) {
                        System.out.printf("dst=%s src=%s (%d bytes): hdrs= %s\n", msg.dest(), msg.src(), msg.getLength(), msg.printHeaders());
                    }
                    break;
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("FailedReadingRequest"), t);
                    return;
                }
            }
            case GET_MBRS: {
                request = this.readRequest(in.position(offset));
                if (request == null) break;
                GossipData rsp = new GossipData(GossipType.GET_MBRS_RSP, request.getGroup(), null);
                Map members = (Map)this.address_mappings.get(request.getGroup());
                if (members != null) {
                    for (Map.Entry entry : members.entrySet()) {
                        Address logical_addr = (Address)entry.getKey();
                        PhysicalAddress phys_addr = ((Entry)entry.getValue()).phys_addr;
                        String logical_name = ((Entry)entry.getValue()).logical_name;
                        PingData data = new PingData(logical_addr, true, logical_name, phys_addr);
                        rsp.addPingData(data);
                    }
                }
                ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(rsp.serializedSize());
                try {
                    rsp.writeTo(out);
                    this.server.send(sender, out.buffer(), 0, out.position());
                }
                catch (Exception ex) {
                    this.log.error("failed sending %d to %s: %s", new Object[]{GossipType.GET_MBRS_RSP, sender, ex});
                }
                break;
            }
            case UNREGISTER: {
                request = this.readRequest(in.position(offset));
                if (request == null) break;
                this.removeAddressMapping(request.getGroup(), request.getAddress());
            }
        }
    }

    @Override
    public void connectionClosed(Connection conn, String reason) {
        this.removeFromAddressMappings(conn.peerAddress());
    }

    @Override
    public void connectionEstablished(Connection conn) {
        this.log.debug("connection to %s established", conn.peerAddress());
    }

    protected GossipData readRequest(ByteArrayDataInputStream in) {
        GossipData data = new GossipData();
        try {
            data.readFrom(in);
            return data;
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedReadingRequest"), ex);
            return null;
        }
    }

    protected void handleRegister(Address sender, GossipData request) {
        String group = request.getGroup();
        Address addr = request.getAddress();
        PhysicalAddress phys_addr = request.getPhysicalAddress();
        String logical_name = request.getLogicalName();
        this.addAddressMapping(sender, group, addr, phys_addr, logical_name);
    }

    protected void addAddressMapping(Address sender, String group, Address addr, PhysicalAddress phys_addr, String logical_name) {
        ConcurrentMap existing;
        ConcurrentMap<Address, Entry> m = (ConcurrentHashMap<Address, Entry>)this.address_mappings.get(group);
        if (m == null && (existing = (ConcurrentMap)this.address_mappings.putIfAbsent(group, m = new ConcurrentHashMap<Address, Entry>())) != null) {
            m = existing;
        }
        m.put(addr, new Entry(sender, phys_addr, logical_name));
    }

    protected void removeAddressMapping(String group, Address addr) {
        Map m = (Map)this.address_mappings.get(group);
        if (m == null) {
            return;
        }
        if (m.remove(addr) != null && m.isEmpty()) {
            this.address_mappings.remove(group);
        }
    }

    protected void removeFromAddressMappings(Address client_addr) {
        if (client_addr == null) {
            return;
        }
        HashSet suspects = null;
        block0: for (Map.Entry entry : this.address_mappings.entrySet()) {
            ConcurrentMap map = (ConcurrentMap)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                Entry e = (Entry)entry2.getValue();
                if (!client_addr.equals(e.client_addr)) continue;
                map.remove(entry2.getKey());
                this.log.debug("connection to %s closed", client_addr);
                if (map.isEmpty()) {
                    this.address_mappings.remove(entry.getKey());
                }
                if (suspects == null) {
                    suspects = new HashSet();
                }
                suspects.add(new Tuple(entry.getKey(), entry2.getKey()));
                continue block0;
            }
        }
        if (this.emit_suspect_events && suspects != null && !suspects.isEmpty()) {
            for (Tuple tuple : suspects) {
                String group = (String)tuple.getVal1();
                Address addr = (Address)tuple.getVal2();
                ConcurrentMap map = (ConcurrentMap)this.address_mappings.get(group);
                if (map == null) continue;
                GossipData data = new GossipData(GossipType.SUSPECT, group, addr);
                this.sendToAllMembersInGroup(map.entrySet(), data);
            }
        }
    }

    protected void route(String group, Address dest, byte[] msg, int offset, int length) {
        ConcurrentMap map = (ConcurrentMap)this.address_mappings.get(group);
        if (map == null) {
            return;
        }
        if (dest != null) {
            Entry entry = (Entry)map.get(dest);
            if (entry != null) {
                this.sendToMember(entry.client_addr, msg, offset, length);
            }
        } else {
            Set<Map.Entry<Address, Entry>> dests = map.entrySet();
            this.sendToAllMembersInGroup(dests, msg, offset, length);
        }
    }

    protected void sendToAllMembersInGroup(Set<Map.Entry<Address, Entry>> dests, GossipData request) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(request.serializedSize());
        try {
            request.writeTo(out);
        }
        catch (Exception ex) {
            this.log.error("failed marshalling gossip data %s: %s; dropping request", request, ex);
            return;
        }
        for (Map.Entry<Address, Entry> entry : dests) {
            Entry e = entry.getValue();
            if (e == null) continue;
            try {
                this.server.send(e.client_addr, out.buffer(), 0, out.position());
            }
            catch (Exception ex) {
                this.log.error("failed sending message to %s (%s): %s", e.logical_name, e.phys_addr, ex);
            }
        }
    }

    protected void sendToAllMembersInGroup(Set<Map.Entry<Address, Entry>> dests, byte[] buf, int offset, int len) {
        for (Map.Entry<Address, Entry> entry : dests) {
            Entry e = entry.getValue();
            if (e == null) continue;
            try {
                this.server.send(e.client_addr, buf, offset, len);
            }
            catch (Exception ex) {
                this.log.error("failed sending message to %s (%s): %s", e.logical_name, e.phys_addr, ex);
            }
        }
    }

    protected void sendToMember(Address dest, GossipData request) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(request.serializedSize());
        try {
            request.writeTo(out);
            this.server.send(dest, out.buffer(), 0, out.position());
        }
        catch (Exception ex) {
            this.log.error("failed sending unicast message to %s: %s", dest, ex);
        }
    }

    protected void sendToMember(Address dest, byte[] buf, int offset, int len) {
        try {
            this.server.send(dest, buf, offset, len);
        }
        catch (Exception ex) {
            this.log.error("failed sending unicast message to %s: %s", dest, ex);
        }
    }

    private void printStartupInfo() {
        System.out.println("GossipRouter started at " + new Date());
        System.out.print("Listening on port " + this.port);
        System.out.println(" bound on address " + this.server.localAddress());
        System.out.print("Backlog is " + this.backlog);
        System.out.print(", linger timeout is " + this.linger_timeout);
        System.out.println(", and read timeout is " + this.sock_read_timeout);
    }

    public static void main(String[] args) throws Exception {
        int port = 12001;
        int backlog = 0;
        long soLinger = -1L;
        long soTimeout = -1L;
        long expiry_time = 60000L;
        GossipRouter router = null;
        String bind_addr = null;
        boolean jmx = true;
        boolean nio = true;
        boolean suspects = true;
        boolean dump_msgs = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg) || "-bind_addr".equals(arg)) {
                bind_addr = args[++i];
                continue;
            }
            if ("-backlog".equals(arg)) {
                backlog = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry_time = Long.parseLong(args[++i]);
                continue;
            }
            if ("-jmx".equals(arg)) {
                jmx = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-solinger".equals(arg)) {
                soLinger = Long.parseLong(args[++i]);
                continue;
            }
            if ("-sotimeout".equals(arg)) {
                soTimeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-nio".equals(arg)) {
                nio = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-suspect".equals(arg)) {
                suspects = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-dump_msgs".equals(arg)) {
                dump_msgs = Boolean.parseBoolean(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        router = new GossipRouter(bind_addr, port).jmx(jmx).expiryTime(expiry_time).useNio(nio).backlog(backlog).socketReadTimeout(soTimeout).lingerTimeout(soLinger).emitSuspectEvents(suspects).dumpMessages(dump_msgs);
        router.start();
        IpAddress local = (IpAddress)router.localAddress();
        System.out.printf("\nGossipRouter listening on %s:%s\n", bind_addr != null ? bind_addr : "0.0.0.0", local.getPort());
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bind_addr <address>] [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        System.out.println("    -backlog <backlog>      - Max queue size of backlogged connections. Must be");
        System.out.println("                              greater than zero or the default of 1000 will be");
        System.out.println("                              used.");
        System.out.println();
        System.out.println("    -jmx <true|false>       - Expose attributes and operations via JMX.");
        System.out.println();
        System.out.println("    -solinger <msecs>       - Time for setting SO_LINGER on connections. 0");
        System.out.println("                              means do not set SO_LINGER. Must be greater than");
        System.out.println("                              or equal to zero or the default of 2000 will be");
        System.out.println("                              used.");
        System.out.println();
        System.out.println("    -sotimeout <msecs>      - Time for setting SO_TIMEOUT on connections. 0");
        System.out.println("                               means don't set SO_TIMEOUT. Must be greater than");
        System.out.println("                               or equal to zero or the default of 3000 will be");
        System.out.println("                               used.");
        System.out.println();
        System.out.println("    -expiry <msecs>         - Time for closing idle connections. 0");
        System.out.println("                              means don't expire.");
        System.out.println();
        System.out.printf("    -nio <true|false>       - Whether or not to use non-blocking connections (NIO)\n", new Object[0]);
        System.out.println();
        System.out.printf("    -suspect <true|false>   - Whether or not to use send SUSPECT events when a conn is closed\n", new Object[0]);
        System.out.println();
        System.out.printf("    -dump_msgs <true|false> - Dumps all messages to stdout after routing them\n", new Object[0]);
        System.out.println();
    }

    protected static class Entry {
        protected final PhysicalAddress phys_addr;
        protected final String logical_name;
        protected final Address client_addr;

        public Entry(Address client_addr, PhysicalAddress phys_addr, String logical_name) {
            this.phys_addr = phys_addr;
            this.logical_name = logical_name;
            this.client_addr = client_addr;
        }

        public String toString() {
            return String.format("client=%s, name=%s, addr=%s", this.client_addr, this.logical_name, this.phys_addr);
        }
    }
}

